//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Texture_CffReader_H
#define Texture_CffReader_H

#include "NodeAttachmentCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Texture
    static const Int32 CFF_TEXTURE_IMAGES_LENGTH_OFFSET                                       = (CFF_NODE_ATTACHMENT_SIZE);
    static const Int32 CFF_TEXTURE_IMAGES_PTR_OFFSET                                          = (4 + CFF_TEXTURE_IMAGES_LENGTH_OFFSET);
    static const Int32 CFF_TEXTURE_TEXTURE_TYPE_OFFSET                                        = (CFF_PTR_SIZE + CFF_TEXTURE_IMAGES_PTR_OFFSET);
    static const Int32 CFF_TEXTURE_TRANSFORM_PTR_OFFSET                                       = (4 + CFF_TEXTURE_TEXTURE_TYPE_OFFSET);
    static const Int32 CFF_TEXTURE_POSITION_OFFSET                                            = (CFF_PTR_SIZE + CFF_TEXTURE_TRANSFORM_PTR_OFFSET);
    static const Int32 CFF_TEXTURE_PIVOT_POINT_OFFSET                                         = (12 + CFF_TEXTURE_POSITION_OFFSET);
    static const Int32 CFF_TEXTURE_ROTATION_OFFSET                                            = (12 + CFF_TEXTURE_PIVOT_POINT_OFFSET);
    static const Int32 CFF_TEXTURE_SCALE_OFFSET                                               = (12 + CFF_TEXTURE_ROTATION_OFFSET);
    static const Int32 CFF_TEXTURE_MAGNIFICATION_FILTER_OFFSET                                = (12 + CFF_TEXTURE_SCALE_OFFSET);
    static const Int32 CFF_TEXTURE_MINIFICATION_FILTER_OFFSET                                 = (4 + CFF_TEXTURE_MAGNIFICATION_FILTER_OFFSET);
    static const Int32 CFF_TEXTURE_MIP_MAP_FILTER_OFFSET                                      = (4 + CFF_TEXTURE_MINIFICATION_FILTER_OFFSET);
    static const Int32 CFF_TEXTURE_WRAP_MODE_U_OFFSET                                         = (4 + CFF_TEXTURE_MIP_MAP_FILTER_OFFSET);
    static const Int32 CFF_TEXTURE_WRAP_MODE_V_OFFSET                                         = (4 + CFF_TEXTURE_WRAP_MODE_U_OFFSET);
    static const Int32 CFF_TEXTURE_ANISOTROPY_OFFSET                                          = (4 + CFF_TEXTURE_WRAP_MODE_V_OFFSET);
    static const Int32 CFF_TEXTURE_SIZE                                                       = (4 + CFF_TEXTURE_ANISOTROPY_OFFSET);

    // getter methods for Texture
    inline Int32 GetTextureImagesLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_IMAGES_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetTextureImages(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXTURE_IMAGES_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetTextureImagesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXTURE_IMAGES_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }
    inline Int32 GetTextureTextureType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_TEXTURE_TYPE_OFFSET);
    }
    inline bool GetOptionalTextureTransform(const AssetDataHandle& handle, const Float*& matrixVector)
    {
        Int32 offsetToValue = CffGetValSafe<Int32>(handle, CFF_TEXTURE_TRANSFORM_PTR_OFFSET);
        if (offsetToValue == -1) {
            return false;
        }
        AssetDataHandle valueHandle = CffGetHandle(CffGetAssetLibHandle(handle), offsetToValue);
        matrixVector = CffGetPtrSafe<Float>(valueHandle, 0);
        return true;
    }
    inline void GetTexturePosition(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_TEXTURE_POSITION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_TEXTURE_POSITION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_TEXTURE_POSITION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetTexturePivotPoint(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_TEXTURE_PIVOT_POINT_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_TEXTURE_PIVOT_POINT_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_TEXTURE_PIVOT_POINT_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetTextureRotation(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_TEXTURE_ROTATION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_TEXTURE_ROTATION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_TEXTURE_ROTATION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetTextureScale(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_TEXTURE_SCALE_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_TEXTURE_SCALE_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_TEXTURE_SCALE_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline Int32 GetTextureMagnificationFilter(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_MAGNIFICATION_FILTER_OFFSET);
    }
    inline Int32 GetTextureMinificationFilter(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_MINIFICATION_FILTER_OFFSET);
    }
    inline Int32 GetTextureMipMapFilter(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_MIP_MAP_FILTER_OFFSET);
    }
    inline Int32 GetTextureWrapModeU(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_WRAP_MODE_U_OFFSET);
    }
    inline Int32 GetTextureWrapModeV(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_WRAP_MODE_V_OFFSET);
    }
    inline Float GetTextureAnisotropy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_TEXTURE_ANISOTROPY_OFFSET);
    }

}}} //namespaces

#endif //Texture_CffReader_H
