//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TextStyleEntry_CffReader_H
#define TextStyleEntry_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TextStyleEntry
    static const Int32 CFF_TEXT_STYLE_ENTRY_FONT_PTR_OFFSET                                   = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_TEXT_STYLE_ENTRY_LOWER_BOUND_OFFSET                                = (CFF_PTR_SIZE + CFF_TEXT_STYLE_ENTRY_FONT_PTR_OFFSET);
    static const Int32 CFF_TEXT_STYLE_ENTRY_UPPER_BOUND_OFFSET                                = (4 + CFF_TEXT_STYLE_ENTRY_LOWER_BOUND_OFFSET);
    static const Int32 CFF_TEXT_STYLE_ENTRY_SIZE                                              = (4 + CFF_TEXT_STYLE_ENTRY_UPPER_BOUND_OFFSET);

    // getter methods for TextStyleEntry
    inline AssetDataHandle GetTextStyleEntryFont(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_TEXT_STYLE_ENTRY_FONT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline UInt32 GetTextStyleEntryLowerBound(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_TEXT_STYLE_ENTRY_LOWER_BOUND_OFFSET);
    }
    inline UInt32 GetTextStyleEntryUpperBound(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_TEXT_STYLE_ENTRY_UPPER_BOUND_OFFSET);
    }

}}} //namespaces

#endif //TextStyleEntry_CffReader_H
