//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TextNode2D_CffReader_H
#define TextNode2D_CffReader_H

#include "RenderNode2DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TextNode2D
    static const Int32 CFF_TEXT_NODE_2D_STYLE_OFFSET                                          = (CFF_RENDER_NODE_2D_SIZE);
    static const Int32 CFF_TEXT_NODE_2D_TEXT_FOR_ASSET_PTR_OFFSET                             = (16 + CFF_TEXT_NODE_2D_STYLE_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_RENDERER_OFFSET                                       = (CFF_PTR_SIZE + CFF_TEXT_NODE_2D_TEXT_FOR_ASSET_PTR_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_IS_TEXT_LAYOUT_ENABLED_OFFSET                         = (4 + CFF_TEXT_NODE_2D_RENDERER_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_IS_MULTI_LINE_ENABLED_OFFSET                          = (4 + CFF_TEXT_NODE_2D_IS_TEXT_LAYOUT_ENABLED_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_IS_WORD_WRAP_ENABLED_OFFSET                           = (4 + CFF_TEXT_NODE_2D_IS_MULTI_LINE_ENABLED_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_TEXT_ALIGNMENT_OFFSET                                 = (4 + CFF_TEXT_NODE_2D_IS_WORD_WRAP_ENABLED_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_TRIMMING_OFFSET                                       = (4 + CFF_TEXT_NODE_2D_TEXT_ALIGNMENT_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_TRIMMING_TEXT_FOR_ASSET_PTR_OFFSET                    = (4 + CFF_TEXT_NODE_2D_TRIMMING_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_LINE_SPACING_OFFSET                                   = (CFF_PTR_SIZE + CFF_TEXT_NODE_2D_TRIMMING_TEXT_FOR_ASSET_PTR_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_IS_ASYNC_PRE_RENDER_ENABLED_OFFSET                    = (4 + CFF_TEXT_NODE_2D_LINE_SPACING_OFFSET);
    static const Int32 CFF_TEXT_NODE_2D_SIZE                                                  = (4 + CFF_TEXT_NODE_2D_IS_ASYNC_PRE_RENDER_ENABLED_OFFSET);

    // getter methods for TextNode2D
    inline const UInt32* GetTextNode2DStyle(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_TEXT_NODE_2D_STYLE_OFFSET);
    }
    inline const Char* GetTextNode2DTextForAsset(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXT_NODE_2D_TEXT_FOR_ASSET_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }
    inline Int32 GetTextNode2DRenderer(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXT_NODE_2D_RENDERER_OFFSET);
    }
    inline bool GetTextNode2DIsTextLayoutEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TEXT_NODE_2D_IS_TEXT_LAYOUT_ENABLED_OFFSET);
    }
    inline bool GetTextNode2DIsMultiLineEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TEXT_NODE_2D_IS_MULTI_LINE_ENABLED_OFFSET);
    }
    inline bool GetTextNode2DIsWordWrapEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TEXT_NODE_2D_IS_WORD_WRAP_ENABLED_OFFSET);
    }
    inline Int32 GetTextNode2DTextAlignment(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXT_NODE_2D_TEXT_ALIGNMENT_OFFSET);
    }
    inline Int32 GetTextNode2DTrimming(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXT_NODE_2D_TRIMMING_OFFSET);
    }
    inline const Char* GetTextNode2DTrimmingTextForAsset(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_TEXT_NODE_2D_TRIMMING_TEXT_FOR_ASSET_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }
    inline UInt16 GetTextNode2DLineSpacing(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt16>(handle, CFF_TEXT_NODE_2D_LINE_SPACING_OFFSET);
    }
    inline bool GetTextNode2DIsAsyncPreRenderEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_TEXT_NODE_2D_IS_ASYNC_PRE_RENDER_ENABLED_OFFSET);
    }

}}} //namespaces

#endif //TextNode2D_CffReader_H
