//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ShaderProgram_CffReader_H
#define ShaderProgram_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ShaderProgram
    static const Int32 CFF_SHADER_PROGRAM_VERTEX_SHADER_BYTES_LENGTH_OFFSET                   = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_SHADER_PROGRAM_VERTEX_SHADER_BYTES_PTR_OFFSET                      = (4 + CFF_SHADER_PROGRAM_VERTEX_SHADER_BYTES_LENGTH_OFFSET);
    static const Int32 CFF_SHADER_PROGRAM_FRAGMENT_SHADER_BYTES_LENGTH_OFFSET                 = (CFF_PTR_SIZE + CFF_SHADER_PROGRAM_VERTEX_SHADER_BYTES_PTR_OFFSET);
    static const Int32 CFF_SHADER_PROGRAM_FRAGMENT_SHADER_BYTES_PTR_OFFSET                    = (4 + CFF_SHADER_PROGRAM_FRAGMENT_SHADER_BYTES_LENGTH_OFFSET);
    static const Int32 CFF_SHADER_PROGRAM_MAX_INSTANCE_COUNT_OFFSET                           = (CFF_PTR_SIZE + CFF_SHADER_PROGRAM_FRAGMENT_SHADER_BYTES_PTR_OFFSET);
    static const Int32 CFF_SHADER_PROGRAM_SIZE                                                = (4 + CFF_SHADER_PROGRAM_MAX_INSTANCE_COUNT_OFFSET);

    // getter methods for ShaderProgram
    inline Int32 GetShaderProgramVertexShaderBytesLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SHADER_PROGRAM_VERTEX_SHADER_BYTES_LENGTH_OFFSET);
    }
    inline Int32 GetShaderProgramVertexShaderBytesRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SHADER_PROGRAM_VERTEX_SHADER_BYTES_PTR_OFFSET);
    }
    inline Int32 GetShaderProgramFragmentShaderBytesLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SHADER_PROGRAM_FRAGMENT_SHADER_BYTES_LENGTH_OFFSET);
    }
    inline Int32 GetShaderProgramFragmentShaderBytesRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SHADER_PROGRAM_FRAGMENT_SHADER_BYTES_PTR_OFFSET);
    }
    inline Int32 GetShaderProgramMaxInstanceCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SHADER_PROGRAM_MAX_INSTANCE_COUNT_OFFSET);
    }

}}} //namespaces

#endif //ShaderProgram_CffReader_H
