//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ScriptParam_CffReader_H
#define ScriptParam_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ScriptParam
    static const Int32 CFF_SCRIPT_PARAM_ITEM_SIZE_OFFSET                                      = (0);
    static const Int32 CFF_SCRIPT_PARAM_NAME_OFFSET                                           = (4 + CFF_SCRIPT_PARAM_ITEM_SIZE_OFFSET);
    static const Int32 CFF_SCRIPT_PARAM_TYPE_OFFSET                                           = (4 + CFF_SCRIPT_PARAM_NAME_OFFSET);
    static const Int32 CFF_SCRIPT_PARAM_VALUE_OFFSET                                          = (4 + CFF_SCRIPT_PARAM_TYPE_OFFSET);
    static const Int32 CFF_SCRIPT_PARAM_SIZE                                                  = (4 + CFF_SCRIPT_PARAM_VALUE_OFFSET);

    // getter methods for ScriptParam
    inline Int32 GetScriptParamItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SCRIPT_PARAM_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetScriptParamName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_SCRIPT_PARAM_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetScriptParamType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SCRIPT_PARAM_TYPE_OFFSET);
    }
    inline const void* GetScriptParamValue(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<void>(handle, CFF_SCRIPT_PARAM_VALUE_OFFSET);
    }

}}} //namespaces

#endif //ScriptParam_CffReader_H
