//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Script_CffReader_H
#define Script_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Script
    static const Int32 CFF_SCRIPT_SCRIPT_BYTES_LENGTH_OFFSET                                  = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_SCRIPT_SCRIPT_BYTES_PTR_OFFSET                                     = (4 + CFF_SCRIPT_SCRIPT_BYTES_LENGTH_OFFSET);
    static const Int32 CFF_SCRIPT_SIZE                                                        = (CFF_PTR_SIZE + CFF_SCRIPT_SCRIPT_BYTES_PTR_OFFSET);

    // getter methods for Script
    inline Int32 GetScriptScriptBytesLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SCRIPT_SCRIPT_BYTES_LENGTH_OFFSET);
    }
    inline Int32 GetScriptScriptBytesRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_SCRIPT_SCRIPT_BYTES_PTR_OFFSET);
    }

}}} //namespaces

#endif //Script_CffReader_H
