//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Scene_CffReader_H
#define Scene_CffReader_H

#include "SceneNodeBaseCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Scene
    static const Int32 CFF_SCENE_CHILDREN_PTR_OFFSET                                          = (CFF_SCENE_NODE_BASE_SIZE);
    static const Int32 CFF_SCENE_THEME_OFFSET                                                 = (CFF_PTR_SIZE + CFF_SCENE_CHILDREN_PTR_OFFSET);
    static const Int32 CFF_SCENE_WIDGETS_PTR_OFFSET                                           = (16 + CFF_SCENE_THEME_OFFSET);
    static const Int32 CFF_SCENE_SCENE_ANIMATION_INFO_PTR_OFFSET                              = (CFF_PTR_SIZE + CFF_SCENE_WIDGETS_PTR_OFFSET);
    static const Int32 CFF_SCENE_SIZE                                                         = (CFF_PTR_SIZE + CFF_SCENE_SCENE_ANIMATION_INFO_PTR_OFFSET);

    // getter methods for Scene
    inline Int32 GetSceneChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_SCENE_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetSceneChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_SCENE_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetSceneChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_SCENE_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }
    inline const UInt32* GetSceneTheme(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_SCENE_THEME_OFFSET);
    }
    inline AssetDataHandle GetSceneWidgets(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_SCENE_WIDGETS_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetSceneSceneAnimationInfoDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_SCENE_SCENE_ANIMATION_INFO_PTR_OFFSET)); 
    }
    inline Int32 GetSceneSceneAnimationInfoCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_SCENE_SCENE_ANIMATION_INFO_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetSceneSceneAnimationInfoElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_SCENE_SCENE_ANIMATION_INFO_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //Scene_CffReader_H
