//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef RenderTarget_CffReader_H
#define RenderTarget_CffReader_H

#include "DynamicItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for RenderTarget
    static const Int32 CFF_RENDER_TARGET_DISPLAY_CFF_SERIALIZABLE_OFFSET                      = (CFF_DYNAMIC_ITEM_SIZE);
    static const Int32 CFF_RENDER_TARGET_RENDER_TARGET_TYPE_OFFSET                            = (16 + CFF_RENDER_TARGET_DISPLAY_CFF_SERIALIZABLE_OFFSET);
    static const Int32 CFF_RENDER_TARGET_CAMERAS_LENGTH_OFFSET                                = (4 + CFF_RENDER_TARGET_RENDER_TARGET_TYPE_OFFSET);
    static const Int32 CFF_RENDER_TARGET_CAMERAS_PTR_OFFSET                                   = (4 + CFF_RENDER_TARGET_CAMERAS_LENGTH_OFFSET);
    static const Int32 CFF_RENDER_TARGET_SIZE                                                 = (CFF_PTR_SIZE + CFF_RENDER_TARGET_CAMERAS_PTR_OFFSET);

    // getter methods for RenderTarget
    inline const UInt32* GetRenderTargetDisplay_CFFSerializable(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_RENDER_TARGET_DISPLAY_CFF_SERIALIZABLE_OFFSET);
    }
    inline Int32 GetRenderTargetRenderTargetType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_TARGET_RENDER_TARGET_TYPE_OFFSET);
    }
    inline Int32 GetRenderTargetCamerasLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_TARGET_CAMERAS_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetRenderTargetCameras(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_RENDER_TARGET_CAMERAS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetRenderTargetCamerasElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_RENDER_TARGET_CAMERAS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }

}}} //namespaces

#endif //RenderTarget_CffReader_H
