//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef RenderOrderBinCollection_CffReader_H
#define RenderOrderBinCollection_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for RenderOrderBinCollection
    static const Int32 CFF_RENDER_ORDER_BIN_COLLECTION_ITEM_SIZE_OFFSET                       = (0);
    static const Int32 CFF_RENDER_ORDER_BIN_COLLECTION_ITEM_TYPE_OFFSET                       = (4 + CFF_RENDER_ORDER_BIN_COLLECTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_COLLECTION_CANDERA_NAME_OFFSET                    = (4 + CFF_RENDER_ORDER_BIN_COLLECTION_ITEM_TYPE_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_COLLECTION_CANDERA_ID_OFFSET                      = (4 + CFF_RENDER_ORDER_BIN_COLLECTION_CANDERA_NAME_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_COLLECTION_CHILDREN_PTR_OFFSET                    = (16 + CFF_RENDER_ORDER_BIN_COLLECTION_CANDERA_ID_OFFSET);
    static const Int32 CFF_RENDER_ORDER_BIN_COLLECTION_SIZE                                   = (CFF_PTR_SIZE + CFF_RENDER_ORDER_BIN_COLLECTION_CHILDREN_PTR_OFFSET);

    // getter methods for RenderOrderBinCollection
    inline Int32 GetRenderOrderBinCollectionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_COLLECTION_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetRenderOrderBinCollectionItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_COLLECTION_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetRenderOrderBinCollectionCanderaName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_COLLECTION_CANDERA_NAME_OFFSET);
        return nameIndex;
    }
    inline const UInt32* GetRenderOrderBinCollectionCanderaId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_RENDER_ORDER_BIN_COLLECTION_CANDERA_ID_OFFSET);
    }
    inline Int32 GetRenderOrderBinCollectionChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_ORDER_BIN_COLLECTION_CHILDREN_PTR_OFFSET);
    }
    inline Int32 GetRenderOrderBinCollectionChildrenCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_RENDER_ORDER_BIN_COLLECTION_CHILDREN_PTR_OFFSET);
    }
    inline AssetDataHandle GetRenderOrderBinCollectionChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_RENDER_ORDER_BIN_COLLECTION_CHILDREN_PTR_OFFSET + (index * CFF_PTR_SIZE));
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //RenderOrderBinCollection_CffReader_H
