//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef RenderMode_CffReader_H
#define RenderMode_CffReader_H

#include "NodeAttachmentCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for RenderMode
    static const Int32 CFF_RENDER_MODE_INHERITANCE_BITMASK_OFFSET                             = (CFF_NODE_ATTACHMENT_SIZE);
    static const Int32 CFF_RENDER_MODE_CULL_MODE_OFFSET                                       = (4 + CFF_RENDER_MODE_INHERITANCE_BITMASK_OFFSET);
    static const Int32 CFF_RENDER_MODE_WIND_MODE_OFFSET                                       = (4 + CFF_RENDER_MODE_CULL_MODE_OFFSET);
    static const Int32 CFF_RENDER_MODE_COLOR_WRITE_ENABLED_OFFSET                             = (4 + CFF_RENDER_MODE_WIND_MODE_OFFSET);
    static const Int32 CFF_RENDER_MODE_IS_DEPTH_WRITE_ENABLED_OFFSET                          = (16 + CFF_RENDER_MODE_COLOR_WRITE_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_MODE_IS_DEPTH_TEST_ENABLED_OFFSET                           = (4 + CFF_RENDER_MODE_IS_DEPTH_WRITE_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_MODE_DEPTH_COMPARISON_FUNCTION_OFFSET                       = (4 + CFF_RENDER_MODE_IS_DEPTH_TEST_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_MODE_DEPTH_BIAS_SCALE_FACTOR_OFFSET                         = (4 + CFF_RENDER_MODE_DEPTH_COMPARISON_FUNCTION_OFFSET);
    static const Int32 CFF_RENDER_MODE_DEPTH_BIAS_UNITS_OFFSET                                = (4 + CFF_RENDER_MODE_DEPTH_BIAS_SCALE_FACTOR_OFFSET);
    static const Int32 CFF_RENDER_MODE_IS_BLENDING_ENABLED_OFFSET                             = (4 + CFF_RENDER_MODE_DEPTH_BIAS_UNITS_OFFSET);
    static const Int32 CFF_RENDER_MODE_BLEND_COLOR_OFFSET                                     = (4 + CFF_RENDER_MODE_IS_BLENDING_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_MODE_SOURCE_BLEND_FACTOR_RGB_OFFSET                         = (16 + CFF_RENDER_MODE_BLEND_COLOR_OFFSET);
    static const Int32 CFF_RENDER_MODE_DEST_BLEND_FACTOR_RGB_OFFSET                           = (4 + CFF_RENDER_MODE_SOURCE_BLEND_FACTOR_RGB_OFFSET);
    static const Int32 CFF_RENDER_MODE_BLEND_OPERATION_RGB_OFFSET                             = (4 + CFF_RENDER_MODE_DEST_BLEND_FACTOR_RGB_OFFSET);
    static const Int32 CFF_RENDER_MODE_SOURCE_BLEND_FACTOR_ALPHA_OFFSET                       = (4 + CFF_RENDER_MODE_BLEND_OPERATION_RGB_OFFSET);
    static const Int32 CFF_RENDER_MODE_DEST_BLEND_FACTOR_ALPHA_OFFSET                         = (4 + CFF_RENDER_MODE_SOURCE_BLEND_FACTOR_ALPHA_OFFSET);
    static const Int32 CFF_RENDER_MODE_BLEND_OPERATION_ALPHA_OFFSET                           = (4 + CFF_RENDER_MODE_DEST_BLEND_FACTOR_ALPHA_OFFSET);
    static const Int32 CFF_RENDER_MODE_IS_STENCIL_TEST_ENABLED_OFFSET                         = (4 + CFF_RENDER_MODE_BLEND_OPERATION_ALPHA_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_COMPARISON_FUNCTION_OFFSET               = (4 + CFF_RENDER_MODE_IS_STENCIL_TEST_ENABLED_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_VALUE_OFFSET                             = (4 + CFF_RENDER_MODE_STENCIL_FRONT_COMPARISON_FUNCTION_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_MASK_OFFSET                              = (4 + CFF_RENDER_MODE_STENCIL_FRONT_VALUE_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_STENCIL_FAIL_OFFSET                      = (4 + CFF_RENDER_MODE_STENCIL_FRONT_MASK_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_DEPTH_FAIL_OFFSET                        = (4 + CFF_RENDER_MODE_STENCIL_FRONT_STENCIL_FAIL_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_DEPTH_PASS_OFFSET                        = (4 + CFF_RENDER_MODE_STENCIL_FRONT_DEPTH_FAIL_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_FRONT_WRITE_MASK_OFFSET                        = (4 + CFF_RENDER_MODE_STENCIL_FRONT_DEPTH_PASS_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_COMPARISON_FUNCTION_OFFSET                = (4 + CFF_RENDER_MODE_STENCIL_FRONT_WRITE_MASK_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_VALUE_OFFSET                              = (4 + CFF_RENDER_MODE_STENCIL_BACK_COMPARISON_FUNCTION_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_MASK_OFFSET                               = (4 + CFF_RENDER_MODE_STENCIL_BACK_VALUE_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_STENCIL_FAIL_OFFSET                       = (4 + CFF_RENDER_MODE_STENCIL_BACK_MASK_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_DEPTH_FAIL_OFFSET                         = (4 + CFF_RENDER_MODE_STENCIL_BACK_STENCIL_FAIL_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_DEPTH_PASS_OFFSET                         = (4 + CFF_RENDER_MODE_STENCIL_BACK_DEPTH_FAIL_OFFSET);
    static const Int32 CFF_RENDER_MODE_STENCIL_BACK_WRITE_MASK_OFFSET                         = (4 + CFF_RENDER_MODE_STENCIL_BACK_DEPTH_PASS_OFFSET);
    static const Int32 CFF_RENDER_MODE_SIZE                                                   = (4 + CFF_RENDER_MODE_STENCIL_BACK_WRITE_MASK_OFFSET);

    // getter methods for RenderMode
    inline UInt32 GetRenderModeInheritanceBitmask(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_RENDER_MODE_INHERITANCE_BITMASK_OFFSET);
    }
    inline Int32 GetRenderModeCullMode(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_CULL_MODE_OFFSET);
    }
    inline Int32 GetRenderModeWindMode(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_WIND_MODE_OFFSET);
    }
    inline void GetRenderModeColorWriteEnabled(const AssetDataHandle& handle, bool& redEnabled, bool& greenEnabled, bool& blueEnabled, bool& alphaEnabled)
    {
        redEnabled = CffGetValSafe<bool>(handle, CFF_RENDER_MODE_COLOR_WRITE_ENABLED_OFFSET);
        greenEnabled = CffGetValSafe<bool>(handle, CFF_RENDER_MODE_COLOR_WRITE_ENABLED_OFFSET + (1 * CFF_BOOL_SIZE));
        blueEnabled = CffGetValSafe<bool>(handle, CFF_RENDER_MODE_COLOR_WRITE_ENABLED_OFFSET + (2 * CFF_BOOL_SIZE));
        alphaEnabled = CffGetValSafe<bool>(handle, CFF_RENDER_MODE_COLOR_WRITE_ENABLED_OFFSET + (3 * CFF_BOOL_SIZE));
    }
    inline bool GetRenderModeIsDepthWriteEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_RENDER_MODE_IS_DEPTH_WRITE_ENABLED_OFFSET);
    }
    inline bool GetRenderModeIsDepthTestEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_RENDER_MODE_IS_DEPTH_TEST_ENABLED_OFFSET);
    }
    inline Int32 GetRenderModeDepthComparisonFunction(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_DEPTH_COMPARISON_FUNCTION_OFFSET);
    }
    inline Float GetRenderModeDepthBiasScaleFactor(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_RENDER_MODE_DEPTH_BIAS_SCALE_FACTOR_OFFSET);
    }
    inline Float GetRenderModeDepthBiasUnits(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_RENDER_MODE_DEPTH_BIAS_UNITS_OFFSET);
    }
    inline bool GetRenderModeIsBlendingEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_RENDER_MODE_IS_BLENDING_ENABLED_OFFSET);
    }
    inline void GetRenderModeBlendColor(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_RENDER_MODE_BLEND_COLOR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_RENDER_MODE_BLEND_COLOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_RENDER_MODE_BLEND_COLOR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_RENDER_MODE_BLEND_COLOR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline Int32 GetRenderModeSourceBlendFactorRGB(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_SOURCE_BLEND_FACTOR_RGB_OFFSET);
    }
    inline Int32 GetRenderModeDestBlendFactorRGB(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_DEST_BLEND_FACTOR_RGB_OFFSET);
    }
    inline Int32 GetRenderModeBlendOperationRGB(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_BLEND_OPERATION_RGB_OFFSET);
    }
    inline Int32 GetRenderModeSourceBlendFactorAlpha(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_SOURCE_BLEND_FACTOR_ALPHA_OFFSET);
    }
    inline Int32 GetRenderModeDestBlendFactorAlpha(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_DEST_BLEND_FACTOR_ALPHA_OFFSET);
    }
    inline Int32 GetRenderModeBlendOperationAlpha(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_BLEND_OPERATION_ALPHA_OFFSET);
    }
    inline bool GetRenderModeIsStencilTestEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_RENDER_MODE_IS_STENCIL_TEST_ENABLED_OFFSET);
    }
    inline Int32 GetRenderModeStencilFrontComparisonFunction(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_COMPARISON_FUNCTION_OFFSET);
    }
    inline Int32 GetRenderModeStencilFrontValue(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_VALUE_OFFSET);
    }
    inline UInt32 GetRenderModeStencilFrontMask(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_MASK_OFFSET);
    }
    inline Int32 GetRenderModeStencilFrontStencilFail(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_STENCIL_FAIL_OFFSET);
    }
    inline Int32 GetRenderModeStencilFrontDepthFail(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_DEPTH_FAIL_OFFSET);
    }
    inline Int32 GetRenderModeStencilFrontDepthPass(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_DEPTH_PASS_OFFSET);
    }
    inline UInt32 GetRenderModeStencilFrontWriteMask(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_RENDER_MODE_STENCIL_FRONT_WRITE_MASK_OFFSET);
    }
    inline Int32 GetRenderModeStencilBackComparisonFunction(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_BACK_COMPARISON_FUNCTION_OFFSET);
    }
    inline Int32 GetRenderModeStencilBackValue(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_BACK_VALUE_OFFSET);
    }
    inline UInt32 GetRenderModeStencilBackMask(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_RENDER_MODE_STENCIL_BACK_MASK_OFFSET);
    }
    inline Int32 GetRenderModeStencilBackStencilFail(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_BACK_STENCIL_FAIL_OFFSET);
    }
    inline Int32 GetRenderModeStencilBackDepthFail(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_BACK_DEPTH_FAIL_OFFSET);
    }
    inline Int32 GetRenderModeStencilBackDepthPass(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_RENDER_MODE_STENCIL_BACK_DEPTH_PASS_OFFSET);
    }
    inline UInt32 GetRenderModeStencilBackWriteMask(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_RENDER_MODE_STENCIL_BACK_WRITE_MASK_OFFSET);
    }

}}} //namespaces

#endif //RenderMode_CffReader_H
