//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef ReflectionCamera_CffReader_H
#define ReflectionCamera_CffReader_H

#include "CameraCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for ReflectionCamera
    static const Int32 CFF_REFLECTION_CAMERA_SOURCE_CAMERA_OFFSET                             = (CFF_CAMERA_SIZE);
    static const Int32 CFF_REFLECTION_CAMERA_PLANE_DIRECTION_OFFSET                           = (16 + CFF_REFLECTION_CAMERA_SOURCE_CAMERA_OFFSET);
    static const Int32 CFF_REFLECTION_CAMERA_PLANE_DISTANCE_OFFSET                            = (12 + CFF_REFLECTION_CAMERA_PLANE_DIRECTION_OFFSET);
    static const Int32 CFF_REFLECTION_CAMERA_SIZE                                             = (4 + CFF_REFLECTION_CAMERA_PLANE_DISTANCE_OFFSET);

    // getter methods for ReflectionCamera
    inline const UInt32* GetReflectionCameraSourceCamera(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_REFLECTION_CAMERA_SOURCE_CAMERA_OFFSET);
    }
    inline void GetReflectionCameraPlaneDirection(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_REFLECTION_CAMERA_PLANE_DIRECTION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_REFLECTION_CAMERA_PLANE_DIRECTION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_REFLECTION_CAMERA_PLANE_DIRECTION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline Float GetReflectionCameraPlaneDistance(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_REFLECTION_CAMERA_PLANE_DISTANCE_OFFSET);
    }

}}} //namespaces

#endif //ReflectionCamera_CffReader_H
