//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef PowerFunction_CffReader_H
#define PowerFunction_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for PowerFunction
    static const Int32 CFF_POWER_FUNCTION_ITEM_SIZE_OFFSET                                    = (0);
    static const Int32 CFF_POWER_FUNCTION_POWER_OFFSET                                        = (4 + CFF_POWER_FUNCTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_POWER_FUNCTION_SIZE                                                = (4 + CFF_POWER_FUNCTION_POWER_OFFSET);

    // getter methods for PowerFunction
    inline Int32 GetPowerFunctionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_POWER_FUNCTION_ITEM_SIZE_OFFSET);
    }
    inline UInt8 GetPowerFunctionPower(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_POWER_FUNCTION_POWER_OFFSET);
    }

}}} //namespaces

#endif //PowerFunction_CffReader_H
