//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef PointSprite_CffReader_H
#define PointSprite_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for PointSprite
    static const Int32 CFF_POINT_SPRITE_POINT_SIZE_OFFSET                                     = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_POINT_SPRITE_POINT_SIZE_SCALE_A_OFFSET                             = (4 + CFF_POINT_SPRITE_POINT_SIZE_OFFSET);
    static const Int32 CFF_POINT_SPRITE_POINT_SIZE_SCALE_B_OFFSET                             = (4 + CFF_POINT_SPRITE_POINT_SIZE_SCALE_A_OFFSET);
    static const Int32 CFF_POINT_SPRITE_POINT_SIZE_SCALE_C_OFFSET                             = (4 + CFF_POINT_SPRITE_POINT_SIZE_SCALE_B_OFFSET);
    static const Int32 CFF_POINT_SPRITE_SIZE                                                  = (4 + CFF_POINT_SPRITE_POINT_SIZE_SCALE_C_OFFSET);

    // getter methods for PointSprite
    inline Float GetPointSpritePointSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_POINT_SPRITE_POINT_SIZE_OFFSET);
    }
    inline Float GetPointSpritePointSizeScaleA(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_POINT_SPRITE_POINT_SIZE_SCALE_A_OFFSET);
    }
    inline Float GetPointSpritePointSizeScaleB(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_POINT_SPRITE_POINT_SIZE_SCALE_B_OFFSET);
    }
    inline Float GetPointSpritePointSizeScaleC(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_POINT_SPRITE_POINT_SIZE_SCALE_C_OFFSET);
    }

}}} //namespaces

#endif //PointSprite_CffReader_H
