//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef PlanarShadow_CffReader_H
#define PlanarShadow_CffReader_H

#include "MeshCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for PlanarShadow
    static const Int32 CFF_PLANAR_SHADOW_LIGHT_OFFSET                                         = (CFF_MESH_SIZE);
    static const Int32 CFF_PLANAR_SHADOW_ALIGNMENT_NODE_OFFSET                                = (16 + CFF_PLANAR_SHADOW_LIGHT_OFFSET);
    static const Int32 CFF_PLANAR_SHADOW_PLANE_DIRECTION_OFFSET                               = (16 + CFF_PLANAR_SHADOW_ALIGNMENT_NODE_OFFSET);
    static const Int32 CFF_PLANAR_SHADOW_PLANE_DISTANCE_OFFSET                                = (12 + CFF_PLANAR_SHADOW_PLANE_DIRECTION_OFFSET);
    static const Int32 CFF_PLANAR_SHADOW_IS_AUTO_VERTEX_BUFFER_ENABLED_OFFSET                 = (4 + CFF_PLANAR_SHADOW_PLANE_DISTANCE_OFFSET);
    static const Int32 CFF_PLANAR_SHADOW_SIZE                                                 = (4 + CFF_PLANAR_SHADOW_IS_AUTO_VERTEX_BUFFER_ENABLED_OFFSET);

    // getter methods for PlanarShadow
    inline const UInt32* GetPlanarShadowLight(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_PLANAR_SHADOW_LIGHT_OFFSET);
    }
    inline const UInt32* GetPlanarShadowAlignmentNode(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_PLANAR_SHADOW_ALIGNMENT_NODE_OFFSET);
    }
    inline void GetPlanarShadowPlaneDirection(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_PLANAR_SHADOW_PLANE_DIRECTION_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_PLANAR_SHADOW_PLANE_DIRECTION_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_PLANAR_SHADOW_PLANE_DIRECTION_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline Float GetPlanarShadowPlaneDistance(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_PLANAR_SHADOW_PLANE_DISTANCE_OFFSET);
    }
    inline bool GetPlanarShadowIsAutoVertexBufferEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_PLANAR_SHADOW_IS_AUTO_VERTEX_BUFFER_ENABLED_OFFSET);
    }

}}} //namespaces

#endif //PlanarShadow_CffReader_H
