//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Material_CffReader_H
#define Material_CffReader_H

#include "NodeAttachmentCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Material
    static const Int32 CFF_MATERIAL_AMBIENT_OFFSET                                            = (CFF_NODE_ATTACHMENT_SIZE);
    static const Int32 CFF_MATERIAL_DIFFUSE_OFFSET                                            = (16 + CFF_MATERIAL_AMBIENT_OFFSET);
    static const Int32 CFF_MATERIAL_EMISSIVE_OFFSET                                           = (16 + CFF_MATERIAL_DIFFUSE_OFFSET);
    static const Int32 CFF_MATERIAL_SPECULAR_OFFSET                                           = (16 + CFF_MATERIAL_EMISSIVE_OFFSET);
    static const Int32 CFF_MATERIAL_POWER_OFFSET                                              = (16 + CFF_MATERIAL_SPECULAR_OFFSET);
    static const Int32 CFF_MATERIAL_SIZE                                                      = (4 + CFF_MATERIAL_POWER_OFFSET);

    // getter methods for Material
    inline void GetMaterialAmbient(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_MATERIAL_AMBIENT_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_MATERIAL_AMBIENT_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_MATERIAL_AMBIENT_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_MATERIAL_AMBIENT_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetMaterialDiffuse(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_MATERIAL_DIFFUSE_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_MATERIAL_DIFFUSE_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_MATERIAL_DIFFUSE_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_MATERIAL_DIFFUSE_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetMaterialEmissive(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_MATERIAL_EMISSIVE_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_MATERIAL_EMISSIVE_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_MATERIAL_EMISSIVE_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_MATERIAL_EMISSIVE_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetMaterialSpecular(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_MATERIAL_SPECULAR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_MATERIAL_SPECULAR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_MATERIAL_SPECULAR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_MATERIAL_SPECULAR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline Float GetMaterialPower(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_MATERIAL_POWER_OFFSET);
    }

}}} //namespaces

#endif //Material_CffReader_H
