//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef LodNodeItemInfo_CffReader_H
#define LodNodeItemInfo_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for LodNodeItemInfo
    static const Int32 CFF_LOD_NODE_ITEM_INFO_LOWER_BOUND_OFFSET                              = (0);
    static const Int32 CFF_LOD_NODE_ITEM_INFO_UPPER_BOUND_OFFSET                              = (4 + CFF_LOD_NODE_ITEM_INFO_LOWER_BOUND_OFFSET);
    static const Int32 CFF_LOD_NODE_ITEM_INFO_SIZE                                            = (4 + CFF_LOD_NODE_ITEM_INFO_UPPER_BOUND_OFFSET);

    // getter methods for LodNodeItemInfo
    inline Float GetLodNodeItemInfoLowerBound(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LOD_NODE_ITEM_INFO_LOWER_BOUND_OFFSET);
    }
    inline Float GetLodNodeItemInfoUpperBound(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_LOD_NODE_ITEM_INFO_UPPER_BOUND_OFFSET);
    }

}}} //namespaces

#endif //LodNodeItemInfo_CffReader_H
