//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Group_CffReader_H
#define Group_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Group
    static const Int32 CFF_GROUP_IS_LAYOUT_ENABLED_OFFSET                                     = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_GROUP_LAYOUT_PTR_OFFSET                                            = (4 + CFF_GROUP_IS_LAYOUT_ENABLED_OFFSET);
    static const Int32 CFF_GROUP_SIZE                                                         = (CFF_PTR_SIZE + CFF_GROUP_LAYOUT_PTR_OFFSET);

    // getter methods for Group
    inline bool GetGroupIsLayoutEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_GROUP_IS_LAYOUT_ENABLED_OFFSET);
    }
    inline AssetDataHandle GetGroupLayout(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_GROUP_LAYOUT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Group_CffReader_H
