//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Group2D_CffReader_H
#define Group2D_CffReader_H

#include "Node2DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Group2D
    static const Int32 CFF_GROUP_2D_IS_LAYOUT_ENABLED_OFFSET                                  = (CFF_NODE_2D_SIZE);
    static const Int32 CFF_GROUP_2D_LAYOUT_PTR_OFFSET                                         = (4 + CFF_GROUP_2D_IS_LAYOUT_ENABLED_OFFSET);
    static const Int32 CFF_GROUP_2D_SIZE                                                      = (CFF_PTR_SIZE + CFF_GROUP_2D_LAYOUT_PTR_OFFSET);

    // getter methods for Group2D
    inline bool GetGroup2DIsLayoutEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_GROUP_2D_IS_LAYOUT_ENABLED_OFFSET);
    }
    inline AssetDataHandle GetGroup2DLayout(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_GROUP_2D_LAYOUT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Group2D_CffReader_H
