//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef DynamicItem_CffReader_H
#define DynamicItem_CffReader_H

#include "DynamicPropertyHostCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for DynamicItem
    static const Int32 CFF_DYNAMIC_ITEM_CANDERA_TYPE_NAME_OFFSET                              = (CFF_DYNAMIC_PROPERTY_HOST_SIZE);
    static const Int32 CFF_DYNAMIC_ITEM_DYNAMIC_PROPERTIES_PTR_OFFSET                         = (4 + CFF_DYNAMIC_ITEM_CANDERA_TYPE_NAME_OFFSET);
    static const Int32 CFF_DYNAMIC_ITEM_SIZE                                                  = (CFF_PTR_SIZE + CFF_DYNAMIC_ITEM_DYNAMIC_PROPERTIES_PTR_OFFSET);

    // getter methods for DynamicItem
    inline Int32 GetDynamicItemCanderaTypeName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_DYNAMIC_ITEM_CANDERA_TYPE_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetDynamicItemDynamicPropertiesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_DYNAMIC_ITEM_DYNAMIC_PROPERTIES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle),  offset); 
    }
    inline AssetDataHandle GetDynamicItemDynamicPropertiesElementAt(const AssetDataHandle& handle, Int32 elementSize, Int32 index)
    {
        Int32 listOffset =  CffGetValSafe<Int32>(handle, CFF_DYNAMIC_ITEM_DYNAMIC_PROPERTIES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(listHandle, CFF_INT_SIZE + (index * elementSize));
    }

}}} //namespaces

#endif //DynamicItem_CffReader_H
