//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Display_CffReader_H
#define Display_CffReader_H

#include "DynamicItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Display
    static const Int32 CFF_DISPLAY_DISPLAY_ID_OFFSET                                          = (CFF_DYNAMIC_ITEM_SIZE);
    static const Int32 CFF_DISPLAY_RESOLUTION_X_OFFSET                                        = (4 + CFF_DISPLAY_DISPLAY_ID_OFFSET);
    static const Int32 CFF_DISPLAY_RESOLUTION_Y_OFFSET                                        = (4 + CFF_DISPLAY_RESOLUTION_X_OFFSET);
    static const Int32 CFF_DISPLAY_USER_RENDER_TARGETS_LENGTH_OFFSET                          = (4 + CFF_DISPLAY_RESOLUTION_Y_OFFSET);
    static const Int32 CFF_DISPLAY_USER_RENDER_TARGETS_PTR_OFFSET                             = (4 + CFF_DISPLAY_USER_RENDER_TARGETS_LENGTH_OFFSET);
    static const Int32 CFF_DISPLAY_ASSOCIATED_RENDER_TARGETS_PTR_OFFSET                       = (CFF_PTR_SIZE + CFF_DISPLAY_USER_RENDER_TARGETS_PTR_OFFSET);
    static const Int32 CFF_DISPLAY_SIZE                                                       = (CFF_PTR_SIZE + CFF_DISPLAY_ASSOCIATED_RENDER_TARGETS_PTR_OFFSET);

    // getter methods for Display
    inline Int32 GetDisplayDisplayId(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_DISPLAY_DISPLAY_ID_OFFSET);
    }
    inline Int32 GetDisplayResolutionX(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_DISPLAY_RESOLUTION_X_OFFSET);
    }
    inline Int32 GetDisplayResolutionY(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_DISPLAY_RESOLUTION_Y_OFFSET);
    }
    inline Int32 GetDisplayUserRenderTargetsLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_DISPLAY_USER_RENDER_TARGETS_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetDisplayUserRenderTargets(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DISPLAY_USER_RENDER_TARGETS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetDisplayUserRenderTargetsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DISPLAY_USER_RENDER_TARGETS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }
    inline const UInt32* const * GetDisplayAssociatedRenderTargets(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DISPLAY_ASSOCIATED_RENDER_TARGETS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetDisplayAssociatedRenderTargetsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DISPLAY_ASSOCIATED_RENDER_TARGETS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }

}}} //namespaces

#endif //Display_CffReader_H
