//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef DevicePackage_CffReader_H
#define DevicePackage_CffReader_H

#include "DynamicItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for DevicePackage
    static const Int32 CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_LENGTH_OFFSET                   = (CFF_DYNAMIC_ITEM_SIZE);
    static const Int32 CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_PTR_OFFSET                      = (4 + CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_LENGTH_OFFSET);
    static const Int32 CFF_DEVICE_PACKAGE_SIZE                                                = (CFF_PTR_SIZE + CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_PTR_OFFSET);

    // getter methods for DevicePackage
    inline Int32 GetDevicePackageUserRenderTargetsLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetDevicePackageUserRenderTargets(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetDevicePackageUserRenderTargetsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_DEVICE_PACKAGE_USER_RENDER_TARGETS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }

}}} //namespaces

#endif //DevicePackage_CffReader_H
