//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Composite2D_CffReader_H
#define Composite2D_CffReader_H

#include "Scene2DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Composite2D
    static const Int32 CFF_COMPOSITE_2D_ANCHORS_PTR_OFFSET                                    = (CFF_SCENE_2D_SIZE);
    static const Int32 CFF_COMPOSITE_2D_COMPOSITE_PROPERTIES_PTR_OFFSET                       = (CFF_PTR_SIZE + CFF_COMPOSITE_2D_ANCHORS_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_LENGTH_OFFSET                    = (CFF_PTR_SIZE + CFF_COMPOSITE_2D_COMPOSITE_PROPERTIES_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_PTR_OFFSET                       = (4 + CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_LENGTH_OFFSET);
    static const Int32 CFF_COMPOSITE_2D_IS_LAYOUT_ENABLED_OFFSET                              = (CFF_PTR_SIZE + CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_PTR_OFFSET);
    static const Int32 CFF_COMPOSITE_2D_LAYOUT_PTR_OFFSET                                     = (4 + CFF_COMPOSITE_2D_IS_LAYOUT_ENABLED_OFFSET);
    static const Int32 CFF_COMPOSITE_2D_SIZE                                                  = (CFF_PTR_SIZE + CFF_COMPOSITE_2D_LAYOUT_PTR_OFFSET);

    // getter methods for Composite2D
    inline AssetDataHandle GetComposite2DAnchors(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_2D_ANCHORS_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline AssetDataHandle GetComposite2DCompositeProperties(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_2D_COMPOSITE_PROPERTIES_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetComposite2DCompositeAnimationsLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_LENGTH_OFFSET);
    }
    inline const UInt32* const * GetComposite2DCompositeAnimations(const AssetDataHandle& handle)
    {
        return CffGetPtr<const UInt32*>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_PTR_OFFSET)), 0);
    }
    inline const UInt32* GetComposite2DCompositeAnimationsElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_COMPOSITE_2D_COMPOSITE_ANIMATIONS_PTR_OFFSET));
        return CffGetPtrSafe<UInt32>(listHandle, (index * CFF_ITEMID_SIZE));
    }
    inline bool GetComposite2DIsLayoutEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_COMPOSITE_2D_IS_LAYOUT_ENABLED_OFFSET);
    }
    inline AssetDataHandle GetComposite2DLayout(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_COMPOSITE_2D_LAYOUT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Composite2D_CffReader_H
