//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CanvasText_CffReader_H
#define CanvasText_CffReader_H

#include "CanvasNodeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CanvasText
    static const Int32 CFF_CANVAS_TEXT_TRANSLATABLE_TEXT_PTR_OFFSET                           = (CFF_CANVAS_NODE_SIZE);
    static const Int32 CFF_CANVAS_TEXT_STYLE_OFFSET                                           = (CFF_PTR_SIZE + CFF_CANVAS_TEXT_TRANSLATABLE_TEXT_PTR_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_HORIZONTAL_TEXT_ALIGNMENT_OFFSET                       = (16 + CFF_CANVAS_TEXT_STYLE_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_IS_MULTI_LINE_ENABLED_OFFSET                           = (4 + CFF_CANVAS_TEXT_HORIZONTAL_TEXT_ALIGNMENT_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_LINE_SPACING_OFFSET                                    = (4 + CFF_CANVAS_TEXT_IS_MULTI_LINE_ENABLED_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_IS_WORD_WRAP_ENABLED_OFFSET                            = (4 + CFF_CANVAS_TEXT_LINE_SPACING_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_TRUNCATION_MODE_OFFSET                                 = (4 + CFF_CANVAS_TEXT_IS_WORD_WRAP_ENABLED_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_TRANSLATABLE_TRUNCATION_TEXT_PTR_OFFSET                = (4 + CFF_CANVAS_TEXT_TRUNCATION_MODE_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_SIZE_OFFSET                                            = (CFF_PTR_SIZE + CFF_CANVAS_TEXT_TRANSLATABLE_TRUNCATION_TEXT_PTR_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_COLOR_OFFSET                                           = (8 + CFF_CANVAS_TEXT_SIZE_OFFSET);
    static const Int32 CFF_CANVAS_TEXT_SIZE                                                   = (16 + CFF_CANVAS_TEXT_COLOR_OFFSET);

    // getter methods for CanvasText
    inline const Char* GetCanvasTextTranslatableText(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_CANVAS_TEXT_TRANSLATABLE_TEXT_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }
    inline const UInt32* GetCanvasTextStyle(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CANVAS_TEXT_STYLE_OFFSET);
    }
    inline Int32 GetCanvasTextHorizontalTextAlignment(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CANVAS_TEXT_HORIZONTAL_TEXT_ALIGNMENT_OFFSET);
    }
    inline bool GetCanvasTextIsMultiLineEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CANVAS_TEXT_IS_MULTI_LINE_ENABLED_OFFSET);
    }
    inline UInt16 GetCanvasTextLineSpacing(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt16>(handle, CFF_CANVAS_TEXT_LINE_SPACING_OFFSET);
    }
    inline bool GetCanvasTextIsWordWrapEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CANVAS_TEXT_IS_WORD_WRAP_ENABLED_OFFSET);
    }
    inline Int32 GetCanvasTextTruncationMode(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CANVAS_TEXT_TRUNCATION_MODE_OFFSET);
    }
    inline const Char* GetCanvasTextTranslatableTruncationText(const AssetDataHandle& handle)
    {
        return CffGetPtr<Char>(CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_CANVAS_TEXT_TRANSLATABLE_TRUNCATION_TEXT_PTR_OFFSET)), CFF_STRINGLENGTH_SIZE);
    }
    inline void GetCanvasTextSize(const AssetDataHandle& handle, Int32& width, Int32& height)
    {
        width = CffGetValSafe<Int32>(handle, CFF_CANVAS_TEXT_SIZE_OFFSET);
        height = CffGetValSafe<Int32>(handle, CFF_CANVAS_TEXT_SIZE_OFFSET + (1 * CFF_INT_SIZE));
    }
    inline void GetCanvasTextColor(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_CANVAS_TEXT_COLOR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_CANVAS_TEXT_COLOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_CANVAS_TEXT_COLOR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_CANVAS_TEXT_COLOR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }

}}} //namespaces

#endif //CanvasText_CffReader_H
