//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef CanvasRenderable_CffReader_H
#define CanvasRenderable_CffReader_H

#include "CanvasNodeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for CanvasRenderable
    static const Int32 CFF_CANVAS_RENDERABLE_TARGET_TEXTURE_OFFSET                            = (CFF_CANVAS_NODE_SIZE);
    static const Int32 CFF_CANVAS_RENDERABLE_RECTANGLE_OFFSET                                 = (4 + CFF_CANVAS_RENDERABLE_TARGET_TEXTURE_OFFSET);
    static const Int32 CFF_CANVAS_RENDERABLE_SIZE                                             = (16 + CFF_CANVAS_RENDERABLE_RECTANGLE_OFFSET);

    // getter methods for CanvasRenderable
    inline UInt8 GetCanvasRenderableTargetTexture(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt8>(handle, CFF_CANVAS_RENDERABLE_TARGET_TEXTURE_OFFSET);
    }
    inline void GetCanvasRenderableRectangle(const AssetDataHandle& handle, Float& left, Float& top, Float& width, Float& height)
    {
        left = CffGetValSafe<Float>(handle, CFF_CANVAS_RENDERABLE_RECTANGLE_OFFSET);
        top = CffGetValSafe<Float>(handle, CFF_CANVAS_RENDERABLE_RECTANGLE_OFFSET + (1 * CFF_FLOAT_SIZE));
        width = CffGetValSafe<Float>(handle, CFF_CANVAS_RENDERABLE_RECTANGLE_OFFSET + (2 * CFF_FLOAT_SIZE));
        height = CffGetValSafe<Float>(handle, CFF_CANVAS_RENDERABLE_RECTANGLE_OFFSET + (3 * CFF_FLOAT_SIZE));
    }

}}} //namespaces

#endif //CanvasRenderable_CffReader_H
