//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Camera_CffReader_H
#define Camera_CffReader_H

#include "Node3DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Camera
    static const Int32 CFF_CAMERA_RENDER_TARGET_OFFSET                                        = (CFF_NODE_3D_SIZE);
    static const Int32 CFF_CAMERA_LOOKAT_NODE_OFFSET                                          = (16 + CFF_CAMERA_RENDER_TARGET_OFFSET);
    static const Int32 CFF_CAMERA_LOOKAT_VECTOR_OFFSET                                        = (16 + CFF_CAMERA_LOOKAT_NODE_OFFSET);
    static const Int32 CFF_CAMERA_UP_VECTOR_OFFSET                                            = (12 + CFF_CAMERA_LOOKAT_VECTOR_OFFSET);
    static const Int32 CFF_CAMERA_VIEWPORT_OFFSET                                             = (12 + CFF_CAMERA_UP_VECTOR_OFFSET);
    static const Int32 CFF_CAMERA_IS_COLOR_CLEAR_ENABLED_OFFSET                               = (16 + CFF_CAMERA_VIEWPORT_OFFSET);
    static const Int32 CFF_CAMERA_CLEAR_COLOR_OFFSET                                          = (4 + CFF_CAMERA_IS_COLOR_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_CLEAR_DEPTH_OFFSET                                          = (16 + CFF_CAMERA_CLEAR_COLOR_OFFSET);
    static const Int32 CFF_CAMERA_IS_DEPTH_CLEAR_ENABLED_OFFSET                               = (4 + CFF_CAMERA_CLEAR_DEPTH_OFFSET);
    static const Int32 CFF_CAMERA_STENCIL_CLEAR_VALUE_OFFSET                                  = (4 + CFF_CAMERA_IS_DEPTH_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_IS_STENCIL_CLEAR_ENABLED_OFFSET                             = (4 + CFF_CAMERA_STENCIL_CLEAR_VALUE_OFFSET);
    static const Int32 CFF_CAMERA_SCISSOR_RECTANGLE_OFFSET                                    = (4 + CFF_CAMERA_IS_STENCIL_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_IS_SCISSORING_ENABLED_OFFSET                                = (16 + CFF_CAMERA_SCISSOR_RECTANGLE_OFFSET);
    static const Int32 CFF_CAMERA_SEQUENCE_NUMBER_OFFSET                                      = (4 + CFF_CAMERA_IS_SCISSORING_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_IS_VIEWING_FRUSTUM_CULLING_ENABLED_OFFSET                   = (4 + CFF_CAMERA_SEQUENCE_NUMBER_OFFSET);
    static const Int32 CFF_CAMERA_IS_SWAP_ENABLED_OFFSET                                      = (4 + CFF_CAMERA_IS_VIEWING_FRUSTUM_CULLING_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_PROJECTION_TYPE_OFFSET                                      = (4 + CFF_CAMERA_IS_SWAP_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_ZNEAR_OFFSET                                                = (4 + CFF_CAMERA_PROJECTION_TYPE_OFFSET);
    static const Int32 CFF_CAMERA_ZFAR_OFFSET                                                 = (4 + CFF_CAMERA_ZNEAR_OFFSET);
    static const Int32 CFF_CAMERA_FOV_OFFSET                                                  = (4 + CFF_CAMERA_ZFAR_OFFSET);
    static const Int32 CFF_CAMERA_ASPECT_OFFSET                                               = (4 + CFF_CAMERA_FOV_OFFSET);
    static const Int32 CFF_CAMERA_WIDTH_OFFSET                                                = (4 + CFF_CAMERA_ASPECT_OFFSET);
    static const Int32 CFF_CAMERA_HEIGHT_OFFSET                                               = (4 + CFF_CAMERA_WIDTH_OFFSET);
    static const Int32 CFF_CAMERA_PROJECTION_MATRIX_OFFSET                                    = (4 + CFF_CAMERA_HEIGHT_OFFSET);
    static const Int32 CFF_CAMERA_RENDER_STRATEGY_OFFSET                                      = (64 + CFF_CAMERA_PROJECTION_MATRIX_OFFSET);
    static const Int32 CFF_CAMERA_BENCHMARK_TRESHOLD_OFFSET                                   = (4 + CFF_CAMERA_RENDER_STRATEGY_OFFSET);
    static const Int32 CFF_CAMERA_QUERY_TYPE_OFFSET                                           = (4 + CFF_CAMERA_BENCHMARK_TRESHOLD_OFFSET);
    static const Int32 CFF_CAMERA_APPLY_CAMERA_ALPHA_OFFSET                                   = (4 + CFF_CAMERA_QUERY_TYPE_OFFSET);
    static const Int32 CFF_CAMERA_SIZE                                                        = (4 + CFF_CAMERA_APPLY_CAMERA_ALPHA_OFFSET);

    // getter methods for Camera
    inline const UInt32* GetCameraRenderTarget(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CAMERA_RENDER_TARGET_OFFSET);
    }
    inline const UInt32* GetCameraLookatNode(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CAMERA_LOOKAT_NODE_OFFSET);
    }
    inline void GetCameraLookatVector(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_CAMERA_LOOKAT_VECTOR_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_CAMERA_LOOKAT_VECTOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_CAMERA_LOOKAT_VECTOR_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetCameraUpVector(const AssetDataHandle& handle, Float& x, Float& y, Float& z)
    {
        x = CffGetValSafe<Float>(handle, CFF_CAMERA_UP_VECTOR_OFFSET);
        y = CffGetValSafe<Float>(handle, CFF_CAMERA_UP_VECTOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        z = CffGetValSafe<Float>(handle, CFF_CAMERA_UP_VECTOR_OFFSET + (2 * CFF_FLOAT_SIZE));
    }
    inline void GetCameraViewport(const AssetDataHandle& handle, Float& left, Float& top, Float& width, Float& height)
    {
        left = CffGetValSafe<Float>(handle, CFF_CAMERA_VIEWPORT_OFFSET);
        top = CffGetValSafe<Float>(handle, CFF_CAMERA_VIEWPORT_OFFSET + (1 * CFF_FLOAT_SIZE));
        width = CffGetValSafe<Float>(handle, CFF_CAMERA_VIEWPORT_OFFSET + (2 * CFF_FLOAT_SIZE));
        height = CffGetValSafe<Float>(handle, CFF_CAMERA_VIEWPORT_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline bool GetCameraIsColorClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_IS_COLOR_CLEAR_ENABLED_OFFSET);
    }
    inline void GetCameraClearColor(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_CAMERA_CLEAR_COLOR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_CAMERA_CLEAR_COLOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_CAMERA_CLEAR_COLOR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_CAMERA_CLEAR_COLOR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline Float GetCameraClearDepth(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_CLEAR_DEPTH_OFFSET);
    }
    inline bool GetCameraIsDepthClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_IS_DEPTH_CLEAR_ENABLED_OFFSET);
    }
    inline Int32 GetCameraStencilClearValue(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CAMERA_STENCIL_CLEAR_VALUE_OFFSET);
    }
    inline bool GetCameraIsStencilClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_IS_STENCIL_CLEAR_ENABLED_OFFSET);
    }
    inline void GetCameraScissorRectangle(const AssetDataHandle& handle, Float& left, Float& top, Float& width, Float& height)
    {
        left = CffGetValSafe<Float>(handle, CFF_CAMERA_SCISSOR_RECTANGLE_OFFSET);
        top = CffGetValSafe<Float>(handle, CFF_CAMERA_SCISSOR_RECTANGLE_OFFSET + (1 * CFF_FLOAT_SIZE));
        width = CffGetValSafe<Float>(handle, CFF_CAMERA_SCISSOR_RECTANGLE_OFFSET + (2 * CFF_FLOAT_SIZE));
        height = CffGetValSafe<Float>(handle, CFF_CAMERA_SCISSOR_RECTANGLE_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline bool GetCameraIsScissoringEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_IS_SCISSORING_ENABLED_OFFSET);
    }
    inline Int32 GetCameraSequenceNumber(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CAMERA_SEQUENCE_NUMBER_OFFSET);
    }
    inline bool GetCameraIsViewingFrustumCullingEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_IS_VIEWING_FRUSTUM_CULLING_ENABLED_OFFSET);
    }
    inline bool GetCameraIsSwapEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_IS_SWAP_ENABLED_OFFSET);
    }
    inline Int32 GetCameraProjectionType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CAMERA_PROJECTION_TYPE_OFFSET);
    }
    inline Float GetCameraZNear(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_ZNEAR_OFFSET);
    }
    inline Float GetCameraZFar(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_ZFAR_OFFSET);
    }
    inline Float GetCameraFov(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_FOV_OFFSET);
    }
    inline Float GetCameraAspect(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_ASPECT_OFFSET);
    }
    inline Float GetCameraWidth(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_WIDTH_OFFSET);
    }
    inline Float GetCameraHeight(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_HEIGHT_OFFSET);
    }
    inline void GetCameraProjectionMatrix(const AssetDataHandle& handle, const Float*& matrixVector)
    {
        matrixVector = CffGetPtrSafe<Float>(handle, CFF_CAMERA_PROJECTION_MATRIX_OFFSET);
    }
    inline Int32 GetCameraRenderStrategy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CAMERA_RENDER_STRATEGY_OFFSET);
    }
    inline Float GetCameraBenchmarkTreshold(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_CAMERA_BENCHMARK_TRESHOLD_OFFSET);
    }
    inline Int32 GetCameraQueryType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_CAMERA_QUERY_TYPE_OFFSET);
    }
    inline bool GetCameraApplyCameraAlpha(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_APPLY_CAMERA_ALPHA_OFFSET);
    }

}}} //namespaces

#endif //Camera_CffReader_H
