//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Camera2D_CffReader_H
#define Camera2D_CffReader_H

#include "Node2DCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Camera2D
    static const Int32 CFF_CAMERA_2D_RENDER_TARGET_OFFSET                                     = (CFF_NODE_2D_SIZE);
    static const Int32 CFF_CAMERA_2D_VIEWPORT_OFFSET                                          = (16 + CFF_CAMERA_2D_RENDER_TARGET_OFFSET);
    static const Int32 CFF_CAMERA_2D_CLEAR_COLOR_OFFSET                                       = (16 + CFF_CAMERA_2D_VIEWPORT_OFFSET);
    static const Int32 CFF_CAMERA_2D_IS_COLOR_CLEAR_ENABLED_OFFSET                            = (16 + CFF_CAMERA_2D_CLEAR_COLOR_OFFSET);
    static const Int32 CFF_CAMERA_2D_SCISSOR_RECTANGLE_OFFSET                                 = (4 + CFF_CAMERA_2D_IS_COLOR_CLEAR_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_2D_IS_SCISSORING_ENABLED_OFFSET                             = (16 + CFF_CAMERA_2D_SCISSOR_RECTANGLE_OFFSET);
    static const Int32 CFF_CAMERA_2D_SEQUENCE_NUMBER_OFFSET                                   = (4 + CFF_CAMERA_2D_IS_SCISSORING_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_2D_IS_SWAP_ENABLED_OFFSET                                   = (4 + CFF_CAMERA_2D_SEQUENCE_NUMBER_OFFSET);
    static const Int32 CFF_CAMERA_2D_APPLY_CAMERA_ALPHA_OFFSET                                = (4 + CFF_CAMERA_2D_IS_SWAP_ENABLED_OFFSET);
    static const Int32 CFF_CAMERA_2D_SIZE                                                     = (4 + CFF_CAMERA_2D_APPLY_CAMERA_ALPHA_OFFSET);

    // getter methods for Camera2D
    inline const UInt32* GetCamera2DRenderTarget(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_CAMERA_2D_RENDER_TARGET_OFFSET);
    }
    inline void GetCamera2DViewport(const AssetDataHandle& handle, Float& left, Float& top, Float& width, Float& height)
    {
        left = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_VIEWPORT_OFFSET);
        top = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_VIEWPORT_OFFSET + (1 * CFF_FLOAT_SIZE));
        width = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_VIEWPORT_OFFSET + (2 * CFF_FLOAT_SIZE));
        height = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_VIEWPORT_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline void GetCamera2DClearColor(const AssetDataHandle& handle, Float& red, Float& green, Float& blue, Float& alpha)
    {
        red = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_CLEAR_COLOR_OFFSET);
        green = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_CLEAR_COLOR_OFFSET + (1 * CFF_FLOAT_SIZE));
        blue = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_CLEAR_COLOR_OFFSET + (2 * CFF_FLOAT_SIZE));
        alpha = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_CLEAR_COLOR_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline bool GetCamera2DIsColorClearEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_2D_IS_COLOR_CLEAR_ENABLED_OFFSET);
    }
    inline void GetCamera2DScissorRectangle(const AssetDataHandle& handle, Float& left, Float& top, Float& width, Float& height)
    {
        left = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_SCISSOR_RECTANGLE_OFFSET);
        top = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_SCISSOR_RECTANGLE_OFFSET + (1 * CFF_FLOAT_SIZE));
        width = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_SCISSOR_RECTANGLE_OFFSET + (2 * CFF_FLOAT_SIZE));
        height = CffGetValSafe<Float>(handle, CFF_CAMERA_2D_SCISSOR_RECTANGLE_OFFSET + (3 * CFF_FLOAT_SIZE));
    }
    inline bool GetCamera2DIsScissoringEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_2D_IS_SCISSORING_ENABLED_OFFSET);
    }
    inline Int16 GetCamera2DSequenceNumber(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int16>(handle, CFF_CAMERA_2D_SEQUENCE_NUMBER_OFFSET);
    }
    inline bool GetCamera2DIsSwapEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_2D_IS_SWAP_ENABLED_OFFSET);
    }
    inline bool GetCamera2DApplyCameraAlpha(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_CAMERA_2D_APPLY_CAMERA_ALPHA_OFFSET);
    }

}}} //namespaces

#endif //Camera2D_CffReader_H
