//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BoolAnimationKeyframe_CffReader_H
#define BoolAnimationKeyframe_CffReader_H

#include "BaseAnimationKeyframeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BoolAnimationKeyframe
    static const Int32 CFF_BOOL_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET                          = (CFF_BASE_ANIMATION_KEYFRAME_SIZE);
    static const Int32 CFF_BOOL_ANIMATION_KEYFRAME_SIZE                                       = (CFF_PTR_SIZE + CFF_BOOL_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);

    // getter methods for BoolAnimationKeyframe
    inline Int32 GetBoolAnimationKeyframeValuesCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BOOL_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);
    }
    inline bool GetBoolAnimationKeyframeValuesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<bool>(handle, CFF_INT_SIZE + CFF_BOOL_ANIMATION_KEYFRAME_VALUES_PTR_OFFSET + (index * CFF_BOOL_SIZE));
    }

}}} //namespaces

#endif //BoolAnimationKeyframe_CffReader_H
