//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BlendLodStrategy_CffReader_H
#define BlendLodStrategy_CffReader_H

#include "LodStrategyCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BlendLodStrategy
    static const Int32 CFF_BLEND_LOD_STRATEGY_IS_DEPTH_BIAS_ENABLED_OFFSET                    = (CFF_LOD_STRATEGY_SIZE);
    static const Int32 CFF_BLEND_LOD_STRATEGY_OPAQUE_ROB_OFFSET                               = (4 + CFF_BLEND_LOD_STRATEGY_IS_DEPTH_BIAS_ENABLED_OFFSET);
    static const Int32 CFF_BLEND_LOD_STRATEGY_TRANSPARENT_ROB_OFFSET                          = (16 + CFF_BLEND_LOD_STRATEGY_OPAQUE_ROB_OFFSET);
    static const Int32 CFF_BLEND_LOD_STRATEGY_SIZE                                            = (16 + CFF_BLEND_LOD_STRATEGY_TRANSPARENT_ROB_OFFSET);

    // getter methods for BlendLodStrategy
    inline bool GetBlendLodStrategyIsDepthBiasEnabled(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_BLEND_LOD_STRATEGY_IS_DEPTH_BIAS_ENABLED_OFFSET);
    }
    inline const UInt32* GetBlendLodStrategyOpaqueROB(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_BLEND_LOD_STRATEGY_OPAQUE_ROB_OFFSET);
    }
    inline const UInt32* GetBlendLodStrategyTransparentROB(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_BLEND_LOD_STRATEGY_TRANSPARENT_ROB_OFFSET);
    }

}}} //namespaces

#endif //BlendLodStrategy_CffReader_H
