//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef BackFunction_CffReader_H
#define BackFunction_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for BackFunction
    static const Int32 CFF_BACK_FUNCTION_ITEM_SIZE_OFFSET                                     = (0);
    static const Int32 CFF_BACK_FUNCTION_AMPLITUDE_OFFSET                                     = (4 + CFF_BACK_FUNCTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_BACK_FUNCTION_SIZE                                                 = (4 + CFF_BACK_FUNCTION_AMPLITUDE_OFFSET);

    // getter methods for BackFunction
    inline Int32 GetBackFunctionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_BACK_FUNCTION_ITEM_SIZE_OFFSET);
    }
    inline Float GetBackFunctionAmplitude(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_BACK_FUNCTION_AMPLITUDE_OFFSET);
    }

}}} //namespaces

#endif //BackFunction_CffReader_H
