//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AssetHeader_CffReader_H
#define AssetHeader_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    static const UInt32 CFF_ASSET_FILEVERSION_OFFSET = 0U;
    static const UInt32 CFF_ASSET_FILESIZE_OFFSET = 4U + CFF_ASSET_FILEVERSION_OFFSET;
    static const UInt32 CFF_ASSET_FILETIMESTAMP_OFFSET = 4U + CFF_ASSET_FILESIZE_OFFSET;
    static const UInt32 CFF_ASSET_SOLUTIONGUID_OFFSET = 8U + CFF_ASSET_FILETIMESTAMP_OFFSET;
    static const UInt32 CFF_ASSET_CUSTOMID_OFFSET = 16U + CFF_ASSET_SOLUTIONGUID_OFFSET;
    static const UInt32 CFF_ASSET_SCENECOMPOSERVERSION_OFFSET = 8U + CFF_ASSET_CUSTOMID_OFFSET;
    static const UInt32 CFF_ASSET_CANDERAVERSION_OFFSET = 16U + CFF_ASSET_SCENECOMPOSERVERSION_OFFSET;
    static const UInt32 CFF_ASSET_WIDGETSETVERSION_OFFSET = 16U + CFF_ASSET_CANDERAVERSION_OFFSET;
    static const UInt32 CFF_ASSET_WIDGETHASH_OFFSET = 8U + CFF_ASSET_WIDGETSETVERSION_OFFSET;
    static const UInt32 CFF_ASSET_VERSION_SIZE = 8U + CFF_ASSET_WIDGETHASH_OFFSET;
    static const UInt32 CFF_ASSET_NAMETABLE_OFFSET = CFF_ASSET_VERSION_SIZE;
    static const UInt32 CFF_ASSET_DEVICEPACKAGE_OFFSET = 4U + CFF_ASSET_NAMETABLE_OFFSET;
    static const UInt32 CFF_ASSET_DEFAULTRENDERMODE_OFFSET = 4U + CFF_ASSET_DEVICEPACKAGE_OFFSET;
    static const UInt32 CFF_ASSET_AUTOUNIFORMS_OFFSET = 4U + CFF_ASSET_DEFAULTRENDERMODE_OFFSET;
    static const UInt32 CFF_ASSET_SHADERATTRIBUTES_OFFSET = 4U + CFF_ASSET_AUTOUNIFORMS_OFFSET;
    static const UInt32 CFF_ASSET_PLATFORMNAME_OFFSET = 4U + CFF_ASSET_SHADERATTRIBUTES_OFFSET;
    static const UInt32 CFF_ASSET_PLATFORMINSTANCENAME_OFFSET = 4U + CFF_ASSET_PLATFORMNAME_OFFSET;
    static const UInt32 CFF_ASSET_FNREPR_OFFSET = 4U + CFF_ASSET_PLATFORMINSTANCENAME_OFFSET;
    static const UInt32 CFF_ASSET_DEFAULTCULTURE_OFFSET = 4U + CFF_ASSET_FNREPR_OFFSET;
    static const UInt32 CFF_ASSET_MASTERTHEMENAME_OFFSET = 4U + CFF_ASSET_DEFAULTCULTURE_OFFSET;
    static const UInt32 CFF_ASSET_SIMULATIONSHADERS_OFFSET = 4U + CFF_ASSET_MASTERTHEMENAME_OFFSET;
    static const UInt32 CFF_ASSET_MAX_BITMAP_GLYPH_SIZE_OFFSET = 4U + CFF_ASSET_SIMULATIONSHADERS_OFFSET;
    static const UInt32 CFF_ASSET_TRANSITION_RULE_COLLECTION_OFFSET = 4U + CFF_ASSET_MAX_BITMAP_GLYPH_SIZE_OFFSET;
    static const UInt32 CFF_ASSET_PARTITION_INDEX_OFFSET = 4U + CFF_ASSET_TRANSITION_RULE_COLLECTION_OFFSET;
    static const UInt32 CFF_ASSET_HEADER_SIZE = 4U + CFF_ASSET_PARTITION_INDEX_OFFSET;

    inline Int32 GetAssetFileVersion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ASSET_FILEVERSION_OFFSET);
    }

    inline UInt32 GetAssetFileSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_FILESIZE_OFFSET);
    }

    inline Int64 GetAssetFileTimeStamp(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int64>(handle, CFF_ASSET_FILETIMESTAMP_OFFSET);
    }

    inline const Char* GetAssetSolutionGUID(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<Char>(handle, CFF_ASSET_SOLUTIONGUID_OFFSET);
    }

    inline Int64 GetAssetCustomId(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int64>(handle, CFF_ASSET_CUSTOMID_OFFSET);
    }

    inline const Int32* GetAssetSceneComposerVersion(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<Int32>(handle, CFF_ASSET_SOLUTIONGUID_OFFSET);
    }

    inline const Int32* GetAssetCanderaVersion(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<Int32>(handle, CFF_ASSET_CANDERAVERSION_OFFSET);
    }

    inline Int32 GetAssetWidgetSetVersion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ASSET_WIDGETSETVERSION_OFFSET);
    }

    inline UInt32 GetAssetWidgetHash(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_WIDGETHASH_OFFSET);
    }

    inline UInt32 GetAssetNametableOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_NAMETABLE_OFFSET);
    }

    inline UInt32 GetAssetDevicePackageOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_DEVICEPACKAGE_OFFSET);
    }

    inline UInt32 GetAssetDefaultRederModeOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_DEFAULTRENDERMODE_OFFSET);
    }

    inline UInt32 GetAssetAutoUniformsOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_AUTOUNIFORMS_OFFSET);
    }

    inline UInt32 GetAssetShaderAtributesOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_SHADERATTRIBUTES_OFFSET);
    }

    inline UInt32 GetAssetPlatformName(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_PLATFORMNAME_OFFSET);
    }

    inline UInt32 GetAssetPlatformInstanceName(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_PLATFORMINSTANCENAME_OFFSET);
    }

    inline UInt32 GetAssetFractionalNumberRepresentation(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_FNREPR_OFFSET);
    }

    inline UInt32 GetAssetDefaultCultureName(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_DEFAULTCULTURE_OFFSET);
    }

    inline UInt32 GetAssetMasterThemeName(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_MASTERTHEMENAME_OFFSET);
    }

    inline bool GetAssetSimulationShaders(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_ASSET_SIMULATIONSHADERS_OFFSET);
    }

    inline Int32 GetAssetMaximumBitmapGlyphSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ASSET_MAX_BITMAP_GLYPH_SIZE_OFFSET);
    }

    inline UInt32 GetTransitionRuleCollectionOffset(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_ASSET_TRANSITION_RULE_COLLECTION_OFFSET);
    }

    inline Int32 GetAssetPartitionIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ASSET_PARTITION_INDEX_OFFSET);
    }



}}} //namespaces

#endif //AssetHeader_CffReader_H
