//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Appearance_CffReader_H
#define Appearance_CffReader_H

#include "NodeAttachmentCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Appearance
    static const Int32 CFF_APPEARANCE_RESOLVED_SHADER_PROGRAM_OFFSET                          = (CFF_NODE_ATTACHMENT_SIZE);
    static const Int32 CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_TYPE_OFFSET                = (16 + CFF_APPEARANCE_RESOLVED_SHADER_PROGRAM_OFFSET);
    static const Int32 CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_PTR_OFFSET                 = (4 + CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_TYPE_OFFSET);
    static const Int32 CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_TYPE_OFFSET             = (CFF_PTR_SIZE + CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_PTR_OFFSET);
    static const Int32 CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_PTR_OFFSET              = (4 + CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_TYPE_OFFSET);
    static const Int32 CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_TYPE_OFFSET  = (CFF_PTR_SIZE + CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_PTR_OFFSET);
    static const Int32 CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_PTR_OFFSET  = (4 + CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_TYPE_OFFSET);
    static const Int32 CFF_APPEARANCE_TEXTURES_PTR_OFFSET                                     = (CFF_PTR_SIZE + CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_PTR_OFFSET);
    static const Int32 CFF_APPEARANCE_SIZE                                                    = (CFF_PTR_SIZE + CFF_APPEARANCE_TEXTURES_PTR_OFFSET);

    // getter methods for Appearance
    inline const UInt32* GetAppearanceResolvedShaderProgram(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_APPEARANCE_RESOLVED_SHADER_PROGRAM_OFFSET);
    }
    inline Int32 GetAppearanceResolvedMaterialAttachmentType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_TYPE_OFFSET);
    }
    inline const UInt32* GetAppearanceResolvedMaterialAttachmentId(const AssetDataHandle& handle)
    {
        return CffGetPtr<UInt32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_PTR_OFFSET));
    }
    inline AssetDataHandle GetAppearanceResolvedMaterialAttachment(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_MATERIAL_ATTACHMENT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetAppearanceResolvedRenderModeAttachmentType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_TYPE_OFFSET);
    }
    inline const UInt32* GetAppearanceResolvedRenderModeAttachmentId(const AssetDataHandle& handle)
    {
        return CffGetPtr<UInt32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_PTR_OFFSET));
    }
    inline AssetDataHandle GetAppearanceResolvedRenderModeAttachment(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_RENDER_MODE_ATTACHMENT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline Int32 GetAppearanceResolvedUniformSetterForAssetAttachmentType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_TYPE_OFFSET);
    }
    inline const UInt32* GetAppearanceResolvedUniformSetterForAssetAttachmentId(const AssetDataHandle& handle)
    {
        return CffGetPtr<UInt32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_PTR_OFFSET));
    }
    inline AssetDataHandle GetAppearanceResolvedUniformSetterForAssetAttachment(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_APPEARANCE_RESOLVED_UNIFORM_SETTER_FOR_ASSET_ATTACHMENT_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }
    inline AssetDataHandle GetAppearanceTextures(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_APPEARANCE_TEXTURES_PTR_OFFSET);
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //Appearance_CffReader_H
