//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AnimationKeyframeSequence_CffReader_H
#define AnimationKeyframeSequence_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for AnimationKeyframeSequence
    static const Int32 CFF_ANIMATION_KEYFRAME_SEQUENCE_ITEM_SIZE_OFFSET                       = (0);
    static const Int32 CFF_ANIMATION_KEYFRAME_SEQUENCE_INTERPOLATION_STRATEGY_OFFSET          = (4 + CFF_ANIMATION_KEYFRAME_SEQUENCE_ITEM_SIZE_OFFSET);
    static const Int32 CFF_ANIMATION_KEYFRAME_SEQUENCE_IS_PERIODIC_OFFSET                     = (4 + CFF_ANIMATION_KEYFRAME_SEQUENCE_INTERPOLATION_STRATEGY_OFFSET);
    static const Int32 CFF_ANIMATION_KEYFRAME_SEQUENCE_KEYFRAMES_PTR_OFFSET                   = (4 + CFF_ANIMATION_KEYFRAME_SEQUENCE_IS_PERIODIC_OFFSET);
    static const Int32 CFF_ANIMATION_KEYFRAME_SEQUENCE_SIZE                                   = (CFF_PTR_SIZE + CFF_ANIMATION_KEYFRAME_SEQUENCE_KEYFRAMES_PTR_OFFSET);

    // getter methods for AnimationKeyframeSequence
    inline Int32 GetAnimationKeyframeSequenceItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATION_KEYFRAME_SEQUENCE_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetAnimationKeyframeSequenceInterpolationStrategy(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATION_KEYFRAME_SEQUENCE_INTERPOLATION_STRATEGY_OFFSET);
    }
    inline bool GetAnimationKeyframeSequenceIsPeriodic(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_ANIMATION_KEYFRAME_SEQUENCE_IS_PERIODIC_OFFSET);
    }
    inline Int32 GetAnimationKeyframeSequenceKeyframesCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATION_KEYFRAME_SEQUENCE_KEYFRAMES_PTR_OFFSET);
    }
    inline AssetDataHandle GetAnimationKeyframeSequenceKeyframesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_ANIMATION_KEYFRAME_SEQUENCE_KEYFRAMES_PTR_OFFSET + (index * CFF_PTR_SIZE));
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //AnimationKeyframeSequence_CffReader_H
