//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AnimationGroup_CffReader_H
#define AnimationGroup_CffReader_H

#include "AnimationBaseCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for AnimationGroup
    static const Int32 CFF_ANIMATION_GROUP_PARTIAL_CHILDREN_PTR_OFFSET                        = (CFF_ANIMATION_BASE_SIZE);
    static const Int32 CFF_ANIMATION_GROUP_SIZE                                               = (CFF_PTR_SIZE + CFF_ANIMATION_GROUP_PARTIAL_CHILDREN_PTR_OFFSET);

    // getter methods for AnimationGroup
    inline Int32 GetAnimationGroupPartialChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_ANIMATION_GROUP_PARTIAL_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetAnimationGroupPartialChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_ANIMATION_GROUP_PARTIAL_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetAnimationGroupPartialChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_ANIMATION_GROUP_PARTIAL_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //AnimationGroup_CffReader_H
