//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AnimationBase_CffReader_H
#define AnimationBase_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for AnimationBase
    static const Int32 CFF_ANIMATION_BASE_SPEED_FACTOR_OFFSET                                 = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_ANIMATION_BASE_REPEAT_COUNT_OFFSET                                 = (4 + CFF_ANIMATION_BASE_SPEED_FACTOR_OFFSET);
    static const Int32 CFF_ANIMATION_BASE_REPEAT_MODE_OFFSET                                  = (4 + CFF_ANIMATION_BASE_REPEAT_COUNT_OFFSET);
    static const Int32 CFF_ANIMATION_BASE_SIZE                                                = (4 + CFF_ANIMATION_BASE_REPEAT_MODE_OFFSET);

    // getter methods for AnimationBase
    inline Float GetAnimationBaseSpeedFactor(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Float>(handle, CFF_ANIMATION_BASE_SPEED_FACTOR_OFFSET);
    }
    inline Int32 GetAnimationBaseRepeatCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATION_BASE_REPEAT_COUNT_OFFSET);
    }
    inline Int32 GetAnimationBaseRepeatMode(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANIMATION_BASE_REPEAT_MODE_OFFSET);
    }

}}} //namespaces

#endif //AnimationBase_CffReader_H
