//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef AnchorDefinitionCollection_CffReader_H
#define AnchorDefinitionCollection_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for AnchorDefinitionCollection
    static const Int32 CFF_ANCHOR_DEFINITION_COLLECTION_ITEM_SIZE_OFFSET                      = (0);
    static const Int32 CFF_ANCHOR_DEFINITION_COLLECTION_ITEM_TYPE_OFFSET                      = (4 + CFF_ANCHOR_DEFINITION_COLLECTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_ANCHOR_DEFINITION_COLLECTION_CANDERA_NAME_OFFSET                   = (4 + CFF_ANCHOR_DEFINITION_COLLECTION_ITEM_TYPE_OFFSET);
    static const Int32 CFF_ANCHOR_DEFINITION_COLLECTION_CANDERA_ID_OFFSET                     = (4 + CFF_ANCHOR_DEFINITION_COLLECTION_CANDERA_NAME_OFFSET);
    static const Int32 CFF_ANCHOR_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET                   = (16 + CFF_ANCHOR_DEFINITION_COLLECTION_CANDERA_ID_OFFSET);
    static const Int32 CFF_ANCHOR_DEFINITION_COLLECTION_SIZE                                  = (CFF_PTR_SIZE + CFF_ANCHOR_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET);

    // getter methods for AnchorDefinitionCollection
    inline Int32 GetAnchorDefinitionCollectionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANCHOR_DEFINITION_COLLECTION_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetAnchorDefinitionCollectionItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANCHOR_DEFINITION_COLLECTION_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetAnchorDefinitionCollectionCanderaName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_ANCHOR_DEFINITION_COLLECTION_CANDERA_NAME_OFFSET);
        return nameIndex;
    }
    inline const UInt32* GetAnchorDefinitionCollectionCanderaId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_ANCHOR_DEFINITION_COLLECTION_CANDERA_ID_OFFSET);
    }
    inline Int32 GetAnchorDefinitionCollectionChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_ANCHOR_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET);
    }
    inline Int32 GetAnchorDefinitionCollectionChildrenCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_ANCHOR_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET);
    }
    inline AssetDataHandle GetAnchorDefinitionCollectionChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_ANCHOR_DEFINITION_COLLECTION_CHILDREN_PTR_OFFSET + (index * CFF_PTR_SIZE));
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //AnchorDefinitionCollection_CffReader_H
