//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETPROVIDERDISPATCHER_H)
#define CANDERA_ASSETPROVIDERDISPATCHER_H

#include <Candera/Environment.h>
#include <FeatStd/Async/AsyncRequestDispatcher.h>

namespace Candera {
/** @addtogroup AssetLoaderBase
 *  @{
 */

    namespace Internal {

        /**
         * Wrapper for the asset loader worker thread.
         */
        class ThreadedAssetProviderDispatcher
        {
            public:
                ThreadedAssetProviderDispatcher();
                ~ThreadedAssetProviderDispatcher();
                FeatStd::AsyncRequestDispatcher& GetRequestDispatcher();

                FeatStd::UInt32 GetWorkerThreadId() const { return m_dispatcher.GetThreadId(); }

                FeatStd::AsyncRequestDispatcherWorkerThread *GetWorkerThread() { return &m_dispatcher; }

            private:
                bool Init();

                FeatStd::AsyncRequestDispatcherWorkerThread m_dispatcher;
                bool m_init;
        };

        /**
         * Wrapper for the async dispatcher of the single threaded asset loader.
         */
        class AsyncAssetProviderDispatcher
        {
            public:
                AsyncAssetProviderDispatcher();
                ~AsyncAssetProviderDispatcher();
                FeatStd::AsyncRequestDispatcher& GetRequestDispatcher();

                FeatStd::AsyncRequestDispatcherWorkerThread *GetWorkerThread() { return static_cast<FeatStd::AsyncRequestDispatcherWorkerThread*>(0); }

            private:
                FeatStd::AsyncRequestDispatcher m_dispatcher;
        };
    }


 /** @} */ // end of AssetLoaderBase
}
#endif // CANDERA_ASSETPROVIDER_H
