//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETLOADERDATATYPE_H)
#define CANDERA_ASSETLOADERDATATYPE_H

#include <Candera/EngineBase/DataTypes/CanderaObjectDataType.h>

#ifdef CANDERA_META_DESCRIPTION
#define AssetLoaderDataTypeGetEditorDef(scPropertyEditor) \
    static const Char* GetEditor() { return scPropertyEditor; }
#else
#define AssetLoaderDataTypeGetEditorDef(scPropertyEditor)
#endif

#define AssetLoaderDataTypeDef(type, scPropertyEditor) \
    template<> struct DataType< type> { \
    static inline bool ConvertToString(type const& ptr, Char *buf, UInt bufLen) { \
        return Candera::MetaInfo::CanderaObjectConverterToString<type>::ConvertToString(ptr, buf, bufLen); \
    }; \
    static bool ConvertFromString(type &destination, const Char *buf, AssetProvider* provider = 0); \
    AssetLoaderDataTypeGetEditorDef(scPropertyEditor) \
    };

#define AssetLoaderDataTypeDecl(type, getter) \
    bool DataType< type>::ConvertFromString(type &destination, const Char *buf, AssetProvider* provider) { \
    return AssetLoaderConverterFromString< type, getter>::ConvertFromString(destination, buf, provider); \
    }

#endif // CANDERA_ASSETLOADERDATATYPE_H
