//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETLOADERBASEDATATYPES_H)
#define CANDERA_ASSETLOADERBASEDATATYPES_H

#include <Candera/EngineBase/DataTypes/CanderaObjectDataType.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLoaderDataType.h>
#include <Candera/EngineBase/Common/BaseStringBufferAppenders.h>

namespace Candera {
    class Bitmap;
    class ImageSource2D;
    class ImageSource3D;
    class RenderTarget2D;
    class RenderTarget3D;
    class SharedClearMode;
    class SharedClearMode2D;
    class WidgetBase;
    class Behavior;
    class CameraGroup;
    class GraphicDeviceUnit;

    namespace Animation {
        class AnimationPlayerBase;
        class AnimationPlayer;
        class AnimationGroupPlayer;
    }

    namespace TextRendering {
        class SharedStyle;
    }

    namespace Internal {
        class StateMachineBehaviorData;
    }

    namespace MetaInfo {
        namespace Internal {
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<TextRendering::SharedStyle>, "builtin://TextStyleEditor")
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<Bitmap>, "builtin://BitmapEditor")
            AssetLoaderDataTypeDef(WidgetBase*, "builtin://WidgetEditor")
            AssetLoaderDataTypeDef(Behavior*, "builtin://BehaviorEditor")
            AssetLoaderDataTypeDef(CameraGroup*, "builtin://CameraGroupEditor")
            AssetLoaderDataTypeDef(Candera::Internal::StateMachineBehaviorData*, "builtin://StateMachineEditor")
            AssetLoaderDataTypeDef(GraphicDeviceUnit*, "builtin://RenderTargetEditor")
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<Animation::AnimationPlayerBase>, "builtin://AnimationBaseEditor")
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<SharedClearMode>, "builtin://ClearModeEditor")
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<Animation::AnimationPlayer>, "builtin://AnimationEditor")
            AssetLoaderDataTypeDef(FeatStd::MemoryManagement::SharedPointer<Animation::AnimationGroupPlayer>, "builtin://AnimationGroupEditor")
            AssetLoaderDataTypeDef(ImageSource3D*, "builtin://RenderTargetEditor")
            AssetLoaderDataTypeDef(ImageSource2D*, "builtin://RenderTargetEditor")
            AssetLoaderDataTypeDef(RenderTarget3D*, "builtin://RenderTargetEditor")
            AssetLoaderDataTypeDef(RenderTarget2D*, "builtin://RenderTargetEditor")

            template<> struct DataType<FeatStd::MemoryManagement::SharedPointer<SharedClearMode2D> >
            {
                static bool ConvertToString(const FeatStd::MemoryManagement::SharedPointer<SharedClearMode2D> &clearMode, Char *buf, UInt bufLen);
                static bool ConvertFromString(FeatStd::MemoryManagement::SharedPointer<SharedClearMode2D> &clearMode, const Char *buf);
                static const Char* GetEditor() { return "builtin://ColorEditor"; }
            };
        }
    }
}

#endif // CANDERA_ASSETLOADERBASEDATATYPES_H
