//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSET_HEADINFO_H)
    #define CANDERA_ASSET_HEADINFO_H

#include <Candera/Environment.h>
#include <Candera/System/Container/Vector.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>

namespace Candera {

    /**
     * Asset informations collected during AssetReader initialization phase
     */
    struct AssetData {
        typedef Internal::Vector<const Char*> NameList;

        bool m_simulationShaders;
        NameList m_nameList[c_libCount];
        const Char* m_masterThemeName;
        const Char* m_platformName;
        const Char* m_platformInstanceName;
        const Char* m_fractionalNumberRepresentation;
        const Char* m_defaultCulture;

        struct AssetVersionInfo {
            Int32 m_fileVersion;
            UInt32 m_fileSize;
            Int64 m_fileTimestamp;
            UInt32 m_widgetHash;
            Int32 m_canderaVersion[4];
            Int32 m_widgetSetVersion;
            Char m_solutionGuid[16];
            Int64 m_customId;
            Int32 m_sceneComposerVersion[4];
        } m_versionInfo;
    };
}

#endif
