//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETIDMACROS_H)
#define CANDERA_ASSETIDMACROS_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>

namespace Candera {
    
    static const Id c_invalidAssetId = 0U;

#define CDA_SHARED_LIBRARY_ASSETID(sclId, libraryId, instanceId) \
        (FeatStd::UInt32(1U) << Candera::Internal::AssetIdFunctions::c_validityBit) | \
        (FeatStd::UInt32(1U) << Candera::Internal::AssetIdFunctions::c_isLibraryIdBit) | \
        (FeatStd::UInt32(1U) << Candera::Internal::AssetIdFunctions::c_isShareableIdBit) | \
        ((static_cast<FeatStd::UInt32>(sclId) & (static_cast<FeatStd::UInt32>(FeatStd::Internal::Limits<Candera::Id>::cMaxValue) >> (FeatStd::UInt32(static_cast<FeatStd::UInt32>(sizeof(Candera::Id)) * FeatStd::UInt32(8U)) - Candera::Internal::AssetIdFunctions::c_sclIdBitSize))) << Candera::Internal::AssetIdFunctions::c_sclIdBitOffset) | \
        ((static_cast<FeatStd::UInt32>(libraryId) & (static_cast<FeatStd::UInt32>(FeatStd::Internal::Limits<Candera::Id>::cMaxValue) >> (FeatStd::UInt32(static_cast<FeatStd::UInt32>(sizeof(Candera::Id)) * FeatStd::UInt32(8U)) - Candera::Internal::AssetIdFunctions::c_sharedLibraryIdBitSize))) << Candera::Internal::AssetIdFunctions::c_sharedLibraryIdBitOffset) | \
        ((static_cast<FeatStd::UInt32>(instanceId) & (static_cast<FeatStd::UInt32>(FeatStd::Internal::Limits<Candera::Id>::cMaxValue) >> (FeatStd::UInt32(static_cast<FeatStd::UInt32>(sizeof(Candera::Id)) * FeatStd::UInt32(8U)) - Candera::Internal::AssetIdFunctions::c_instanceIdBitSize))) << Candera::Internal::AssetIdFunctions::c_instanceIdBitOffset)

#define CDA_LIBRARY_ASSETID(sclId, libraryId) \
        (FeatStd::UInt32(1U) << Candera::Internal::AssetIdFunctions::c_validityBit) | \
        (FeatStd::UInt32(1U) << Candera::Internal::AssetIdFunctions::c_isLibraryIdBit) | \
        ((static_cast<FeatStd::UInt32>(sclId) & (static_cast<FeatStd::UInt32>(FeatStd::Internal::Limits<Candera::Id>::cMaxValue) >> (FeatStd::UInt32(static_cast<FeatStd::UInt32>(sizeof(Candera::Id)) * FeatStd::UInt32(8U)) - Candera::Internal::AssetIdFunctions::c_sclIdBitSize))) << Candera::Internal::AssetIdFunctions::c_sclIdBitOffset) | \
        ((static_cast<FeatStd::UInt32>(libraryId) & (static_cast<FeatStd::UInt32>(FeatStd::Internal::Limits<Candera::Id>::cMaxValue) >> (FeatStd::UInt32(static_cast<FeatStd::UInt32>(sizeof(Candera::Id)) * FeatStd::UInt32(8U)) - Candera::Internal::AssetIdFunctions::c_libraryIdBitSize))) << Candera::Internal::AssetIdFunctions::c_libraryIdBitOffset)

#define CDA_NODE_ASSETID(nodeId) \
    (FeatStd::UInt32(1U) << Candera::Internal::AssetIdFunctions::c_validityBit) | \
        (nodeId & (static_cast<FeatStd::UInt32>(FeatStd::Internal::Limits<Candera::Id>::cMaxValue) >> (FeatStd::UInt32(static_cast<FeatStd::UInt32>(sizeof(Candera::Id)) * FeatStd::UInt32(8U)) - Candera::Internal::AssetIdFunctions::c_nodeIdBitSize))) << Candera::Internal::AssetIdFunctions::c_nodeIdBitOffset

    
}   // namespace Candera


#endif // CANDERA_ASSETIDMACROS_H
