//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ASSETDATAHANDLE_H)
#define CANDERA_ASSETDATAHANDLE_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/Common/ResourceData.h>
#include <Candera/EngineBase/Common/ResourceDataHandle.h>
#include <FeatStd/Util/PointerUtil.h>
namespace Candera {

    namespace Internal {

        static const FeatStd::OffsetType CFF_INVALID_OFFSET = FeatStd::OFFSETTYPE_MAX;
        static const UInt16 NOT_A_REGION = static_cast<UInt16>(~(static_cast<UInt16>(0U)));


        class AssetDataHandle {
            friend bool operator==(const AssetDataHandle& left, const AssetDataHandle& right);

            public:
            AssetDataHandle();
            explicit AssetDataHandle(const ResourceDataHandle& resourceHandle);
            explicit AssetDataHandle(ResourceData resourceObject, OffsetType offset);

            AssetDataHandle operator+(OffsetType offset) const;

            bool IsValid() const;
            bool IsPersistent() const;
            const void* GetData(OffsetType offset) const;

            ResourceData m_resourceObject;
            OffsetType m_offset;
        };

        inline AssetDataHandle::AssetDataHandle():
            m_resourceObject(ResourceDataHandle::InvalidHandle()),
            m_offset(CFF_INVALID_OFFSET)
        {
        }

        inline AssetDataHandle::AssetDataHandle(const ResourceDataHandle& resourceHandle):
            m_resourceObject(resourceHandle),
            m_offset(0)
        {
        }

        inline AssetDataHandle::AssetDataHandle(ResourceData resourceObject, OffsetType offset) :
            m_resourceObject(resourceObject),
            m_offset(offset)
        {
        }

        inline AssetDataHandle AssetDataHandle::operator + (OffsetType offset) const
        {
            return AssetDataHandle(m_resourceObject, m_offset + offset);
        }

        inline bool AssetDataHandle::IsPersistent() const
        {
            return m_resourceObject.IsPersistent();
        }

        inline bool AssetDataHandle::IsValid() const
        {
            return (m_resourceObject.GetData() != 0) && (m_offset != CFF_INVALID_OFFSET);
        }

        inline const void* AssetDataHandle::GetData(OffsetType offset) const
        {
            return FeatStd::Internal::PointerAdd(m_resourceObject.GetData(), m_offset + offset);
        }
        
        inline bool operator==(const AssetDataHandle& left, const AssetDataHandle& right)
        {
            return (left.m_resourceObject == right.m_resourceObject) && (left.m_offset == right.m_offset);
        }

    }   // namespace Internal
}   // namespace Candera

#endif // CANDERA_ASSETDATAHANDLE_H
