//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if  !defined(CANDERA_ASSETCONTEXT_H)
#define CANDERA_ASSETCONTEXT_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetLibHeadInformation.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetGroup.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>

namespace Candera {

/** @addtogroup AssetLoaderBase
 *  @{
 */

    namespace Internal {
        class AssetGroup;
    }
    struct AssetData;

    /**
     * @brief Encapsulates main list of objects' names that define an asset context.
     * The scene context is provided by the DefaultAssetProvider class after it's
     * initialization on a certain compact asset lib file.
     *
     * Using the asset context, one can iterate on the list of scenes or animations
     * available in that asset lib.
     */
    class AssetContext {
        friend class DefaultAssetProvider;

    public:

        enum ShaderParamsType {
            ShaderParamsDefault = 0,    ///< Default shader params
            ShaderParamsSphereMap = 1   ///< Sphere map shader params
        };

        /**
         *  Destructor
         */
        ~AssetContext() {};

    private:
        MemoryManagement::SharedPointer<Candera::Internal::AssetGroup> m_assetGroup;

        Int GetCount(AssetLib assetType) const;
        const Char* GetName(AssetLib assetType, Int index) const;

        /**
         *  Constructor
         *  Class can only be constructed by it's friend classes.
         *  @param assetData The asset data
         *  @param displays  The display
         */
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704,Candera::AssetContext::AssetContext, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
        AssetContext(const MemoryManagement::SharedPointer<Candera::Internal::AssetGroup>& assetGroup);

        //forbid assignment operator, declare it private
        AssetContext& operator=(const AssetContext&);
    };

 /** @} */ // end of AssetLoaderBase

}

#endif //CANDERA_ASSETCONTEXT_H
