//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_AssetCache_H)
#define CANDERA_AssetCache_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/Common/ResourceObject.h>
#include <Candera/System/Container/Map.h>
#include <FeatStd/Util/PointerUtil.h>

namespace Candera {

    class DefaultAssetProvider; 
    namespace Internal {
        
        class AssetCache {
            public:

            typedef ResourceDataHandle::Accessor::Asset Key;
            AssetCache();
            ~AssetCache();
            void* GetAndRetain(const Key& key);
            void* Reserve(const Key& key, UInt32 size);
            void Retain(const void* data) const;
            void Release(const void* data);
            static AssetCache& GetInstance();
            //private:
            struct MetaData {
                UInt32 m_offsetToNextMetaData;
                UInt32 m_retainCount;
                Key m_key;
            };
            
            MetaData* GetMetaData(UInt32 offset)
            {return FeatStd::Internal::PointerAdd<MetaData*>(m_buffer, offset);}
            static const UInt32 c_MetaDataSize = sizeof(MetaData);
            static const UInt32 c_notInCache = static_cast<UInt32>(~static_cast<UInt32>(0U));

            typedef Candera::Internal::Map<Key, MetaData*> LocationMap;
            LocationMap m_locationMap;
            void* m_buffer;
            UInt32 m_nextOffset;

        };


    }   // namespace Internal
}   // namespace Candera

#endif // CANDERA_AssetCache_H
