//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_WIDGETCOLLECTION_BUILDER_H)
#define CANDERA_WIDGETCOLLECTION_BUILDER_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/WidgetBaseAssetBuilder.h>

namespace Candera {
    class WidgetBase;
    namespace Internal {

        class WidgetCollectionAssetBuilderBase {
        public:
            virtual ~WidgetCollectionAssetBuilderBase() {};
            bool CreateAndBuildFirstPass(const CffLoaderContext& context);
            bool BuildSecondPass(const CffLoaderContext& context);
        private:
            virtual bool AddWidget(WidgetBase* widget) = 0;
            virtual WidgetBase* GetFirstWidget() = 0;
            virtual WidgetBase* GetNextWidget() = 0;
        };
    }
}

#endif  // CANDERA_WIDGETCOLLECTION_BUILDER_H
