//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "WidgetCollectionAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/WidgetCollectionCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/CffReader/CanderaObjectCffReader.h>
#include <CanderaAssetLoader/AssetLoaderBase/DefaultAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/WidgetBaseAssetBuilder.h>
#include <CanderaWidget/WidgetBase/WidgetBase.h>

namespace Candera {
    using namespace Diagnostics;

    namespace Internal {
        FEATSTD_LOG_SET_REALM(LogRealm::CanderaAssetLoader);

        bool WidgetCollectionAssetBuilderBase::CreateAndBuildFirstPass(const CffLoaderContext& context)
        {
            if (!context.handle.IsValid()) {
                FEATSTD_LOG_ERROR("Asset error, missing handle for widget collection.");
                return false;
            }

            Int32 widgetCount = CFFReader::GetWidgetCollectionWidgetsFlatCount(context.handle);
            for (Int32 widgetIndex = 0; widgetIndex < widgetCount; ++widgetIndex) {
                const AssetDataHandle& widgetHandle = CFFReader::GetWidgetCollectionWidgetsFlatElementAt(context.handle, widgetIndex);
                if (!widgetHandle.IsValid()) {
                    FEATSTD_LOG_ERROR("Asset error, missing handle for widget.");
                    return false;
                }

                CffLoaderContext widgetContext = context.Clone(widgetHandle);
                WidgetBase* widget = AssetBuilder<WidgetBase*>::CreateAndBuildFirstPass(widgetContext);
                if (widget != 0) {
                    static_cast<void>(AddWidget(widget));
                }
                else {
                    //FEATSTD_LOG_WARN("Widget failed to create for scene %s.", sceneContext.GetScene()->GetName());
                }
            }

            return true;
        }

        bool WidgetCollectionAssetBuilderBase::BuildSecondPass(const CffLoaderContext& context)
        {
            if (!context.handle.IsValid()) {
                FEATSTD_LOG_ERROR("Asset error, missing handle for widget collection.");
                return false;
            }

            Int32 widgetCount = CFFReader::GetWidgetCollectionWidgetsFlatCount(context.handle);
            WidgetBase* widget = GetFirstWidget();
            for (Int32 widgetIndex = 0; widgetIndex < widgetCount; ++widgetIndex) {
                const AssetDataHandle& widgetHandle = CFFReader::GetWidgetCollectionWidgetsFlatElementAt(context.handle, widgetIndex);
                if (!widgetHandle.IsValid()) {
                    FEATSTD_LOG_ERROR("Asset error, missing handle for widget.");
                    return false;
                }

                const AssetId& assetId = AssetIdFunctions::GetAssetId(CFFReader::GetCanderaObjectCanderaId(widgetHandle));
   
                if ((widget == 0) || (widget->GetId() != AssetIdFunctions::GetNodeId(assetId))) {
                    continue;
                }
                
                CffLoaderContext widgetContext = context.Clone(widgetHandle);
                if (!AssetBuilder<WidgetBase*>::BuildSecondPass(widget, widgetContext)) {
                    FEATSTD_LOG_WARN("Widget %s failed to initialize.", widget->GetName());
                }
                
                widget = GetNextWidget();
            }

            return true;
        }
    }
}
