//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_THEMEASSETBUILDER_H)
#define CANDERA_THEMEASSETBUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class Theme;
    namespace Internal {
        AssetLoaderTypeInfo(Candera::Theme, CffLoaderType, void);

        template<>
        class AssetReaderBase<Theme>: public GenericAssetReaderBase<Theme> {
        public:
            static bool ReadFirstPass(Theme& theme, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<Theme*>: public GenericAssetBuilderBase<Theme*> {
        public:
            static Theme* Create(LoaderContext& context);
            static void Dispose(Theme* theme);
        };
    }
}

#endif  // CANDERA_THEMEASSETBUILDER_H
