//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ThemeAssetBuilder.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaAssetLoader/AssetLoaderBase/Theme.h>

namespace Candera {
    using namespace Diagnostics;
    namespace Internal {

        bool AssetReaderBase<Theme>::ReadFirstPass(Candera::Theme& /*theme*/, LoaderContext& /*context*/)
        {
            //theme information is not present in asset anymore.
            return false;
        }

        Candera::Theme* AssetBuilderBase<Candera::Theme*>::Create(LoaderContext& /*context*/)
        {
            return Candera::Theme::Create();
        }

        void AssetBuilderBase<Candera::Theme*>::Dispose(Candera::Theme* theme)
        {
            theme->Dispose();
        }
    }
}
