//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_STACKLAYOUTER_BUILDER_H)
#define CANDERA_STACKLAYOUTER_BUILDER_H

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/LayouterAssetBuilder.h>

namespace Candera {
    class StackLayouter;

    namespace Internal {
        AssetLoaderTypeInfo(Candera::StackLayouter, CffLoaderType, Candera::Layouter);

        template<>
        class AssetReaderBase<StackLayouter>: public GenericAssetReaderBase<StackLayouter> {
        public:
            static bool ReadFirstPass(StackLayouter& layouter, LoaderContext& context);
        };

        template<>
        class AssetBuilderBase<StackLayouter*>: public GenericAssetBuilderBase<StackLayouter*> {
        public:
            static StackLayouter* Create(LoaderContext& context);
        };
    }
}

#endif  // CANDERA_STACKLAYOUTER_BUILDER_H
