//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined CANDERA_SCRIPT_BUILDER_H
#define CANDERA_SCRIPT_BUILDER_H

#include <CanderaScripting/Script.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    namespace Internal {

        AssetLoaderTypeInfo(Candera::Scripting::Script, CffLoaderType, void);

        template<>
        class AssetBuilderBase<MemoryManagement::SharedPointer<Scripting::Script> > : public GenericAssetBuilderBase<MemoryManagement::SharedPointer<Scripting::Script> >{
        public:
            static MemoryManagement::SharedPointer<Scripting::Script> Create(LoaderContext& context);
        };

        typedef Candera::MemoryManagement::SharedPointer<Scripting::Script> ScriptPtr;
        typedef Candera::Internal::AssetBuilderBase<ScriptPtr> ScriptBuilder;
        typedef Candera::Internal::AssetReaderBase<Scripting::Script> ScriptReader;
    }
}
#endif // CANDERA_SCRIPT_BUILDER_H
