//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SCENECONTEXTBASEASSETREADER_H)
#define CANDERA_SCENECONTEXTBASEASSETREADER_H

#include <CanderaAssetLoader/AssetLoaderBase/Generic/AssetBuilder.h>

namespace Candera {
    class SceneContextBase;

    namespace Internal {

        AssetLoaderTypeInfo(SceneContextBase, CffLoaderType, void);

        template<>
        class AssetReaderBase<SceneContextBase>: public GenericAssetReaderBase<SceneContextBase> {
        public:
            static bool ReadFirstPass(SceneContextBase& sceneContext, LoaderContext& context);
            static bool ReadSecondPass(SceneContextBase& sceneContext, LoaderContext& context);
            static void Dispose(SceneContextBase* sceneContext);
        };

        class TemporaryTheme {
            public:
            TemporaryTheme(DefaultAssetProvider& provider, const AssetId& assetId);
            ~TemporaryTheme();
            private:
            FEATSTD_MAKE_CLASS_UNCOPYABLE(TemporaryTheme);
            DefaultAssetProvider& m_provider;
            Id m_originalId;
        };

    }
}

#endif  // CANDERA_SCENECONTEXTBASEASSETREADER_H
